/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.network;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.stargate.network.StargateAddress;
import dev.tauri.jsg.stargate.network.SymbolInterface;
import dev.tauri.jsg.stargate.network.SymbolTypeEnum;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.nbt.CompoundTag;

public class StargateAddressDynamic
extends StargateAddress {
    private int addressSize;

    public StargateAddressDynamic(SymbolTypeEnum<?> symbolType) {
        super(symbolType);
    }

    public StargateAddressDynamic(CompoundTag compound) {
        super(compound);
    }

    public StargateAddressDynamic(ByteBuf buf) {
        super(buf);
    }

    public StargateAddressDynamic(StargateAddress address) {
        super(address.symbolType);
        this.clear();
        this.addAll(address);
    }

    public StargateAddressDynamic(SymbolTypeEnum<?> symbolType, List<SymbolInterface> symbols) {
        super(symbolType);
        this.clear();
        this.addAll(symbols);
    }

    @Override
    protected int getSavedSymbols() {
        return Math.min(this.addressSize, 9);
    }

    public void addSymbol(SymbolInterface symbol) {
        if (this.address.size() == 9) {
            JSG.logger.error("Tried to add symbol to already full address");
            return;
        }
        this.address.add(symbol);
        ++this.addressSize;
    }

    public void addAll(StargateAddress stargateAddress) {
        if (this.address.size() + stargateAddress.address.size() > 9) {
            JSG.logger.error("Tried to add symbols to already populated address");
            return;
        }
        this.address.addAll(stargateAddress.address);
        this.addressSize += stargateAddress.address.size();
    }

    public void addAll(List<SymbolInterface> stargateAddress) {
        if (this.address.size() + stargateAddress.size() > 9) {
            JSG.logger.error("Tried to add symbols to already populated address");
            return;
        }
        this.address.addAll(stargateAddress);
        this.addressSize += stargateAddress.size();
    }

    public void addOrigin() {
        if (this.symbolType.hasOrigin()) {
            this.addSymbol((SymbolInterface)this.symbolType.getOrigin());
        }
    }

    public void clear() {
        this.address.clear();
        this.addressSize = 0;
    }

    public int size() {
        return this.address.size();
    }

    @Override
    public boolean contains(SymbolInterface symbol) {
        return this.address.contains(symbol);
    }

    public boolean validate() {
        return this.symbolType.validateDialedAddress(this);
    }

    public StargateAddress toImmutable() {
        StargateAddress stargateAddress = new StargateAddress(this.symbolType);
        stargateAddress.address.addAll(this.address);
        return stargateAddress;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        compound.m_128405_("size", this.address.size());
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        this.addressSize = compound.m_128451_("size");
        super.deserializeNBT(compound);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.address.size());
        super.toBytes(buf);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.addressSize = buf.readInt();
        super.fromBytes(buf);
    }
}

