/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.network;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.chunkloader.ChunkManager;
import dev.tauri.jsg.helpers.DimensionsHelper;
import dev.tauri.jsg.stargate.StargateTypeEnum;
import dev.tauri.jsg.stargate.network.SymbolTypeEnum;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.INBTSerializable;

public class StargatePos
implements INBTSerializable<CompoundTag> {
    public boolean blacklisted = false;
    public ResourceKey<Level> dimension;
    public BlockPos gatePos;
    private SymbolTypeEnum<?> gateSymbolType;
    private StargateTypeEnum stargateType;
    private String name;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name == null ? "" : this.name;
    }

    public StargatePos(ResourceKey<Level> dimension, BlockPos gatePos, SymbolTypeEnum<?> gateSymbolType, StargateTypeEnum stargateType) {
        this.dimension = dimension;
        this.gatePos = gatePos;
        this.gateSymbolType = gateSymbolType;
        this.stargateType = stargateType;
    }

    public StargatePos(CompoundTag compound) {
        this.deserializeNBT(compound);
    }

    public StargatePos(ByteBuf buf) {
        this.fromBytes(new FriendlyByteBuf(buf));
    }

    public SymbolTypeEnum<?> getGateSymbolType() {
        if (this.gateSymbolType != null) {
            return this.gateSymbolType;
        }
        this.gateSymbolType = this.getBlockEntity().getSymbolType();
        return this.gateSymbolType;
    }

    public StargateTypeEnum getStargateType() {
        if (this.stargateType != null) {
            return this.stargateType;
        }
        this.stargateType = StargateTypeEnum.parse(this.getGateSymbolType());
        return this.stargateType;
    }

    public Level getWorld() {
        return (Level)Objects.requireNonNull(DimensionsHelper.getLevel(this.dimension));
    }

    public StargateAbstractBaseBE getBlockEntity() {
        try {
            BlockEntity tile = this.getWorld().m_7702_(this.gatePos);
            if (tile == null) {
                ChunkManager.forceChunk((ServerLevel)this.getWorld(), new ChunkPos(this.gatePos));
                tile = this.getWorld().m_7702_(this.gatePos);
                ChunkManager.unforceChunk((ServerLevel)this.getWorld(), new ChunkPos(this.gatePos));
            }
            return (StargateAbstractBaseBE)tile;
        }
        catch (Exception e) {
            JSG.logger.error("Error while getting tile entity from SG pos!", (Throwable)e);
            return null;
        }
    }

    public BlockState getBlockState() {
        return this.getWorld().m_8055_(this.gatePos);
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("dim", this.dimension.m_135782_().toString());
        compound.m_128356_("pos", this.gatePos.m_121878_());
        compound.m_128359_("stargatePosName", this.name == null ? "" : this.name);
        if (this.gateSymbolType != null) {
            compound.m_128344_("gateSymbolType", (byte)SymbolTypeEnum.getId(this.gateSymbolType));
        }
        if (this.stargateType != null) {
            compound.m_128405_("stargateTypeSaved", this.stargateType.id);
        }
        compound.m_128379_("blacklisted", this.blacklisted);
        return compound;
    }

    public void deserializeNBT(CompoundTag compound) {
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(compound.m_128461_("dim")));
        this.gatePos = BlockPos.m_122022_((long)compound.m_128454_("pos"));
        this.name = compound.m_128461_("stargatePosName");
        if (compound.m_128441_("gateSymbolType")) {
            this.gateSymbolType = SymbolTypeEnum.byId(compound.m_128445_("gateSymbolType"));
        }
        if (compound.m_128441_("stargateTypeSaved")) {
            this.stargateType = StargateTypeEnum.valueOf(compound.m_128451_("stargateTypeSaved"));
        }
        this.blacklisted = compound.m_128471_("blacklisted");
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_236858_(this.dimension);
        buf.writeLong(this.gatePos.m_121878_());
        if (this.name != null) {
            buf.writeBoolean(true);
            buf.writeInt(this.name.length());
            buf.writeCharSequence((CharSequence)this.name, StandardCharsets.UTF_8);
        } else {
            buf.writeBoolean(false);
        }
        if (this.gateSymbolType != null) {
            buf.writeBoolean(true);
            buf.writeInt(SymbolTypeEnum.getId(this.gateSymbolType));
        } else {
            buf.writeBoolean(false);
        }
        if (this.stargateType != null) {
            buf.writeBoolean(true);
            buf.writeInt(this.stargateType.id);
        } else {
            buf.writeBoolean(false);
        }
        buf.writeBoolean(this.blacklisted);
    }

    public void fromBytes(FriendlyByteBuf buf) {
        this.dimension = buf.m_236801_(Registries.f_256858_);
        this.gatePos = BlockPos.m_122022_((long)buf.readLong());
        if (buf.readBoolean()) {
            int nameSize = buf.readInt();
            this.name = buf.readCharSequence(nameSize, StandardCharsets.UTF_8).toString();
        }
        if (buf.readBoolean()) {
            this.gateSymbolType = SymbolTypeEnum.byId(buf.readInt());
        }
        if (buf.readBoolean()) {
            this.stargateType = StargateTypeEnum.valueOf(buf.readInt());
        }
        this.blacklisted = buf.readBoolean();
    }

    public String toString() {
        return String.format("[dim=%s, pos=%s, name=%s]", this.dimension.m_135782_(), this.gatePos.toString(), this.getName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dimension.hashCode();
        result = 31 * result + (this.gatePos == null ? 0 : this.gatePos.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StargatePos other = (StargatePos)obj;
        if (this.dimension != other.dimension) {
            return false;
        }
        if (this.gatePos == null) {
            return other.gatePos == null;
        }
        return this.gatePos.equals((Object)other.gatePos);
    }
}

