/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.network;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.config.JSGConfig;
import dev.tauri.jsg.loader.OriginsLoader;
import dev.tauri.jsg.loader.model.ModelLoader;
import dev.tauri.jsg.registry.BlockRegistry;
import dev.tauri.jsg.registry.ItemRegistry;
import dev.tauri.jsg.screen.element.tabs.Tab;
import dev.tauri.jsg.screen.element.tabs.TabAddress;
import dev.tauri.jsg.stargate.BiomeOverlayEnum;
import dev.tauri.jsg.stargate.network.StargateAddressDynamic;
import dev.tauri.jsg.stargate.network.SymbolInterface;
import dev.tauri.jsg.stargate.network.SymbolTypeEnum;
import dev.tauri.jsg.stargate.network.SymbolTypeRegistry;
import dev.tauri.jsg.util.I18n;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public enum SymbolMilkyWayEnum implements SymbolInterface
{
    SCULPTOR(0, 19, "Sculptor", "0.obj"),
    SCORPIUS(1, 8, "Scorpius", "1.obj"),
    CENTAURUS(2, 4, "Centaurus", "2.obj"),
    MONOCEROS(3, 31, "Monoceros", "3.obj"),
    ORIGIN(4, 0, "Point of Origin", "4.obj"),
    PEGASUS(5, 18, "Pegasus", "5.obj"),
    ANDROMEDA(6, 21, "Andromeda", "6.obj"),
    SERPENSCAPUT(7, 6, "Serpens Caput", "7.obj"),
    ARIES(8, 23, "Aries", "8.obj"),
    LIBRA(9, 5, "Libra", "9.obj"),
    ERIDANUS(10, 28, "Eridanus", "10.obj"),
    LEOMINOR(11, 37, "Leo Minor", "11.obj"),
    HYDRA(12, 33, "Hydra", "12.obj"),
    SAGITTARIUS(13, 11, "Sagittarius", "13.obj"),
    SEXTANS(14, 36, "Sextans", "14.obj"),
    SCUTUM(15, 10, "Scutum", "15.obj"),
    PISCES(16, 20, "Pisces", "16.obj"),
    VIRGO(17, 2, "Virgo", "17.obj"),
    BOOTES(18, 3, "Bootes", "18.obj"),
    AURIGA(19, 27, "Auriga", "19.obj"),
    CORONAAUSTRALIS(20, 9, "Corona Australis", "20.obj"),
    GEMINI(21, 32, "Gemini", "21.obj"),
    LEO(22, 38, "Leo", "22.obj"),
    CETUS(23, 25, "Cetus", "23.obj"),
    TRIANGULUM(24, 22, "Triangulum", "24.obj"),
    AQUARIUS(25, 17, "Aquarius", "25.obj"),
    MICROSCOPIUM(26, 13, "Microscopium", "26.obj"),
    EQUULEUS(27, 16, "Equuleus", "27.obj"),
    CRATER(28, 1, "Crater", "28.obj"),
    PERSEUS(29, 24, "Perseus", "29.obj"),
    CANCER(30, 35, "Cancer", "30.obj"),
    NORMA(31, 7, "Norma", "31.obj"),
    TAURUS(32, 26, "Taurus", "32.obj"),
    CANISMINOR(33, 30, "Canis Minor", "33.obj"),
    CAPRICORNUS(34, 14, "Capricornus", "34.obj"),
    LYNX(35, 34, "Lynx", "35.obj"),
    ORION(36, 29, "Orion", "36.obj"),
    PISCISAUSTRINUS(37, 15, "Piscis Austrinus", "37.obj"),
    BRB(38, -1, "Bright Red Button", "brb.obj");

    public static final float ANGLE_PER_GLYPH = 9.230769f;
    public final int id;
    public final int angleIndex;
    public final float angle;
    public final String englishName;
    public final String translationKey;
    private final ResourceLocation iconResource;
    private final ResourceLocation modelResource;

    private SymbolMilkyWayEnum(int id, int angleIndex, String englishName, String model) {
        this.id = id;
        this.angleIndex = angleIndex;
        this.angle = 360.0f - (float)angleIndex * 9.230769f;
        this.englishName = englishName;
        this.translationKey = "glyph.jsg.milkyway." + englishName.toLowerCase().replace(" ", "_");
        this.iconResource = new ResourceLocation("jsg", "textures/gui/symbol/milkyway/" + englishName.toLowerCase().replaceAll(" ", "_") + ".png");
        this.modelResource = ModelLoader.INSTANCE.getModelResource("milkyway/" + model);
    }

    @Override
    public boolean brb() {
        return this == BRB;
    }

    @Override
    public boolean origin() {
        return this == ORIGIN;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public float getAngle() {
        return this.angle;
    }

    @Override
    public int getAngleIndex() {
        return this.angleIndex;
    }

    @Override
    public String getEnglishName() {
        return this.englishName;
    }

    public String toString() {
        return this.getEnglishName();
    }

    @Override
    public ResourceLocation getIconResource(int originId) {
        if (this == ORIGIN) {
            if (((Boolean)JSGConfig.Stargate.enableDiffOrigins.get()).booleanValue()) {
                if (originId >= 6) {
                    return OriginsLoader.getResource(OriginsLoader.EnumOriginFileType.TEXTURE, originId);
                }
                return new ResourceLocation("jsg", "textures/gui/symbol/milkyway/origin_" + originId + ".png");
            }
            return new ResourceLocation("jsg", "textures/gui/symbol/milkyway/origin_5.png");
        }
        return this.getIconResource(BiomeOverlayEnum.NORMAL, (ResourceKey<Level>)Level.f_46428_, originId);
    }

    @Override
    public boolean renderIconByMinecraft(int originId) {
        return this != ORIGIN || (Boolean)JSGConfig.Stargate.enableDiffOrigins.get() == false || originId < 6;
    }

    @Override
    public ResourceLocation getIconResource(BiomeOverlayEnum overlay, ResourceKey<Level> dimensionId, int configOrigin) {
        if (this == ORIGIN) {
            return this.getIconResource(StargateClassicBaseBE.getOriginId(overlay, dimensionId, configOrigin));
        }
        return this.iconResource;
    }

    public ResourceLocation getModelResource(BiomeOverlayEnum overlay, ResourceKey<Level> dimensionId, boolean forDHD, boolean lightModel, int configOrigin) {
        return this.getModelResource(overlay, dimensionId, forDHD, lightModel, false, configOrigin);
    }

    private ResourceLocation getModelResource(BiomeOverlayEnum overlay, ResourceKey<Level> dimensionId, boolean forDHD, boolean lightModel, boolean notFound, int configOrigin) {
        if (this == ORIGIN) {
            ResourceLocation modelResource = !notFound ? ModelLoader.INSTANCE.getModelResource("milkyway/" + (!forDHD ? "ring/" : "") + "origin_" + StargateClassicBaseBE.getOriginId(overlay, dimensionId, configOrigin) + (lightModel ? "_light" : "") + ".obj") : ModelLoader.INSTANCE.getModelResource("milkyway/" + (!forDHD ? "ring/" : "") + "origin_5" + (lightModel ? "_light" : "") + ".obj");
            if (ModelLoader.INSTANCE.getModel(modelResource) == null && !notFound) {
                JSG.logger.error("Origin model not loaded!");
                JSG.logger.error(modelResource.toString());
                return this.getModelResource(overlay, dimensionId, forDHD, lightModel, true, configOrigin);
            }
            return modelResource;
        }
        return this.modelResource;
    }

    @Override
    public String localize() {
        return I18n.format(this.translationKey);
    }

    public SymbolTypeEnum<SymbolMilkyWayEnum> getSymbolType() {
        return SymbolTypeRegistry.MILKYWAY;
    }

    @Override
    public boolean isValidForAddress() {
        return !this.brb() && !this.origin();
    }

    @Override
    public SymbolInterface getNext(boolean previous) {
        SymbolMilkyWayEnum symbol;
        int id = this.getId();
        do {
            if ((id += previous ? -1 : 1) >= 0) continue;
            id = 37;
        } while ((symbol = SymbolTypeRegistry.MILKYWAY.valueOf(id %= 38)) == null || !symbol.isValidForAddress());
        return symbol;
    }

    public static class Provider
    extends SymbolTypeEnum<SymbolMilkyWayEnum> {
        private static final Map<Integer, SymbolMilkyWayEnum> ID_MAP = new HashMap<Integer, SymbolMilkyWayEnum>();
        private static final Map<String, SymbolMilkyWayEnum> ENGLISH_NAME_MAP = new HashMap<String, SymbolMilkyWayEnum>();

        @Override
        public SymbolMilkyWayEnum getFirstValidForAddress() {
            return SCULPTOR;
        }

        @Override
        public SymbolMilkyWayEnum getBRB() {
            return BRB;
        }

        @Override
        public int[] getAncientTitlePos() {
            return new int[]{330, 0};
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public Tab.TabBuilder finalizeAddressTab(Tab.TabBuilder builder) {
            return builder.setTexture(new ResourceLocation("jsg", "textures/gui/container_stargate.png"), 512).setBackgroundTextureLocation(176, 0).setIconRenderPos(0, 6).setIconSize(22, 22).setIconTextureLocation(304, 0);
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public TabAddress.SymbolCoords getSymbolCoords(int symbol) {
            return new TabAddress.SymbolCoords(29 + 31 * (symbol % 3), 20 + 28 * (symbol / 3));
        }

        public SymbolMilkyWayEnum[] getValues() {
            return SymbolMilkyWayEnum.values();
        }

        @Override
        public Block getBaseBlock() {
            return (Block)BlockRegistry.STARGATE_MILKYWAY_BASE_BLOCK.get();
        }

        @Override
        public Item getGlyphUpgrade() {
            return (Item)ItemRegistry.CRYSTAL_GLYPH_MILKYWAY.get();
        }

        @Override
        public Block getDHDBlock() {
            return (Block)BlockRegistry.DHD_MILKYWAY.get();
        }

        @Override
        public String getId() {
            return "milkyway";
        }

        @Override
        public int getIconWidth() {
            return 32;
        }

        @Override
        public int getIconHeight() {
            return 32;
        }

        @Override
        public SymbolMilkyWayEnum getSymbolByAngle(float angle) {
            for (SymbolMilkyWayEnum symbol : SymbolMilkyWayEnum.values()) {
                if (symbol.angle != angle) continue;
                return symbol;
            }
            for (SymbolMilkyWayEnum symbol : SymbolMilkyWayEnum.values()) {
                if (symbol.angle != 360.0f - angle) continue;
                return symbol;
            }
            return this.getOrigin();
        }

        @Override
        public float getAngleOfNearest(float angle) {
            int end = 38;
            int loops = 0;
            int temp = end;
            for (int current = 0; current < end; ++current) {
                temp = end - current;
                if (!(angle < this.getAngleByAngIndex(temp) && angle < this.getAngleByAngIndex(temp - 1)) && angle != this.getAngleByAngIndex(temp)) continue;
                return this.getAngleByAngIndex(temp);
            }
            return this.getAngleByAngIndex(temp);
        }

        @Override
        public float getAngleByAngIndex(int index) {
            if (index < 0) {
                index = 0;
            }
            if (index > 38) {
                index = 38;
            }
            for (SymbolMilkyWayEnum symbol : SymbolMilkyWayEnum.values()) {
                if (symbol.angleIndex != index) continue;
                return symbol.angle;
            }
            return 0.0f;
        }

        @Override
        public SymbolMilkyWayEnum getRandomSymbol(Random random) {
            int id;
            while (this.valueOf(id = random.nextInt(38)) == null || !this.valueOf(id).isValidForAddress() || id == SymbolMilkyWayEnum.ORIGIN.id) {
            }
            return this.valueOf(id);
        }

        @Override
        public boolean validateDialedAddress(StargateAddressDynamic stargateAddress) {
            if (stargateAddress.size() < 7) {
                return false;
            }
            return stargateAddress.get(stargateAddress.size() - 1).origin();
        }

        @Override
        public int getMinimalSymbolCountTo(SymbolTypeEnum<?> symbolType, boolean localDial) {
            boolean eightChevrons = (Boolean)JSGConfig.Stargate.pegAndMilkUseEightChevrons.get();
            if (Objects.equals(symbolType.getId(), SymbolTypeRegistry.PEGASUS.getId())) {
                return localDial && !eightChevrons ? 7 : 8;
            }
            if (Objects.equals(symbolType.getId(), SymbolTypeRegistry.MILKYWAY.getId())) {
                return localDial ? 7 : 8;
            }
            if (Objects.equals(symbolType.getId(), SymbolTypeRegistry.UNIVERSE.getId())) {
                return 9;
            }
            return symbolType.getMinimalSymbolCountTo(SymbolTypeRegistry.MILKYWAY, localDial);
        }

        @Override
        public SymbolMilkyWayEnum getOrigin() {
            return ORIGIN;
        }

        @Override
        public int getMaxSymbolsDisplay(boolean hasUpgrade) {
            return hasUpgrade ? 8 : 6;
        }

        @Override
        public float getAnglePerGlyph() {
            return 9.230769f;
        }

        @Override
        public SymbolMilkyWayEnum getTopSymbol() {
            return ORIGIN;
        }

        @Override
        public SymbolMilkyWayEnum valueOf(int id) {
            return ID_MAP.get(id);
        }

        @Override
        public SymbolMilkyWayEnum fromEnglishName(String englishName) {
            return ENGLISH_NAME_MAP.get(englishName.toLowerCase().replace("\u00f6", "o"));
        }

        static {
            for (SymbolMilkyWayEnum symbol : SymbolMilkyWayEnum.values()) {
                ID_MAP.put(symbol.id, symbol);
                ENGLISH_NAME_MAP.put(symbol.englishName.toLowerCase(), symbol);
            }
        }
    }
}

