/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.rig;

import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.blockentity.util.ScheduledTask;
import dev.tauri.jsg.chunkloader.ChunkManager;
import dev.tauri.jsg.sound.JSGSoundHelper;
import dev.tauri.jsg.sound.SoundEventEnum;
import dev.tauri.jsg.stargate.EnumIrisType;
import dev.tauri.jsg.stargate.EnumScheduledTask;
import dev.tauri.jsg.stargate.EnumStargateState;
import dev.tauri.jsg.stargate.StargateClosedReasonEnum;
import dev.tauri.jsg.stargate.network.StargateNetwork;
import dev.tauri.jsg.stargate.network.StargatePos;
import dev.tauri.jsg.stargate.rig.RIGWave;
import dev.tauri.jsg.stargate.rig.StargateRIGManager;
import dev.tauri.jsg.state.stargate.StargateRendererActionState;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class RIGInstance {
    private final StargateRIGManager manager;
    private final int chevronCount;
    private final int animationLength;
    private final RIGWave wave;
    private final long started;
    private int state;
    private boolean isRunning;
    private long nextEntitySpawnIn;

    public RIGInstance(StargateRIGManager manager, RIGWave wave, int chevronCount, int animationLength) {
        this.manager = manager;
        this.wave = wave;
        this.chevronCount = chevronCount;
        this.animationLength = animationLength;
        this.isRunning = true;
        this.started = manager.gate.getLevelNotNull().m_46467_();
        this.state = 0;
    }

    public void tick() {
        if (!this.isRunning) {
            return;
        }
        if (!this.manager.gate.isMerged()) {
            this.end();
        }
        long tick = this.manager.gate.getLevelNotNull().m_46467_();
        if (this.state == 0) {
            this.doIncomingAnimation();
            this.state = 1;
        }
        if (this.state == 1 && tick - this.started >= (long)this.animationLength) {
            this.openGate();
            this.state = 2;
        }
        if (this.state == 2 && tick - this.started >= (long)(this.animationLength + 60)) {
            if (this.manager.gate.getStargateState().engaged()) {
                this.trySpawnEntity();
            } else if (this.manager.gate.getStargateState().idle()) {
                this.end();
            }
        }
    }

    public void end() {
        if (!this.isRunning) {
            return;
        }
        this.isRunning = false;
        this.state = 0;
        this.manager.gate.attemptClose(StargateClosedReasonEnum.AUTOCLOSE);
        this.manager.gate.clearDHDSymbols();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    private void doIncomingAnimation() {
        StargateAbstractBaseBE gate = this.manager.gate;
        if (!gate.canAcceptConnectionFrom(null)) {
            this.end();
            return;
        }
        int period = (int)((double)this.animationLength / 20.0 * 1000.0 / (double)this.chevronCount);
        gate.stargateState = EnumStargateState.INCOMING;
        gate.isIncoming = true;
        if (gate.connectedToGate) {
            StargateAbstractBaseBE targetGate;
            StargatePos targetGatePos = StargateNetwork.INSTANCE.getStargate(gate.getDialedAddress());
            if (targetGatePos != null && (targetGate = targetGatePos.getBlockEntity()) != null) {
                targetGate.stargateState = EnumStargateState.IDLE;
                targetGate.m_6596_();
            }
            gate.connectedToGate = false;
            gate.connectingToGate = false;
        }
        gate.m_6596_();
        if (gate.isIncomingAnimationAllowed(false)) {
            gate.incomingWormhole(this.chevronCount, period);
        } else {
            gate.incomingWormhole(this.chevronCount);
        }
        gate.sendSignal("stargate_incoming_wormhole", new Object[]{this.chevronCount});
        gate.failGate();
    }

    private void openGate() {
        StargateAbstractBaseBE gate = this.manager.gate;
        if (!gate.getStargateState().incoming() || gate.getStargateState().engaged() || gate.getStargateState().unstable()) {
            this.end();
            return;
        }
        gate.targetGatePos = null;
        gate.setOpenedSince();
        ChunkManager.forceChunk((ServerLevel)gate.m_58904_(), new ChunkPos(gate.m_58899_()));
        gate.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.OPEN_GATE, 0, false);
        gate.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_OPEN_SOUND, gate.getOpenSoundDelay()));
        gate.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_HORIZON_LIGHT_BLOCK, EnumScheduledTask.STARGATE_OPEN_SOUND.waitTicks + 19 + gate.getTicksPerHorizonSegment()));
        gate.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_HORIZON_WIDEN, EnumScheduledTask.STARGATE_OPEN_SOUND.waitTicks + 23 + gate.getTicksPerHorizonSegment()));
        gate.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_ENGAGE));
        gate.sendSignal("stargate_open", new Object[]{false});
        gate.activateDHDBRB();
        gate.m_6596_();
        this.nextEntitySpawnIn = 0L;
    }

    private void trySpawnEntity() {
        if (this.wave.hasFinished()) {
            this.end();
            return;
        }
        StargateAbstractBaseBE gate = this.manager.gate;
        ServerLevel level = (ServerLevel)gate.getLevelNotNull();
        BlockPos gateCenter = gate.getGateCenterPos();
        long tick = level.m_46467_();
        if (this.nextEntitySpawnIn < 1L) {
            this.nextEntitySpawnIn = (long)((double)tick + (level.m_213780_().m_188500_() * 3.0 + 1.0) * 20.0);
        }
        if (tick < this.nextEntitySpawnIn) {
            return;
        }
        this.nextEntitySpawnIn = 0L;
        Entity entity = this.wave.getNextEntity(level);
        int posX = gateCenter.m_123341_();
        int posY = gateCenter.m_123342_() - 1;
        int posZ = gateCenter.m_123343_();
        entity.m_6034_((double)posX, (double)posY, (double)posZ);
        StargateClassicBaseBE classicGate = null;
        if (gate instanceof StargateClassicBaseBE) {
            StargateClassicBaseBE classicBaseBE;
            classicGate = classicBaseBE = (StargateClassicBaseBE)gate;
        }
        if (classicGate == null || classicGate.isIrisOpened() || classicGate.getIrisType() == EnumIrisType.NULL) {
            if (level.m_8860_(entity)) {
                JSGSoundHelper.playSoundEvent((Level)level, gateCenter, SoundEventEnum.WORMHOLE_GO);
            }
            return;
        }
        classicGate.hitIris();
    }
}

