/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.rig;

import dev.tauri.jsg.config.IJSONConfigEntry;
import dev.tauri.jsg.stargate.rig.MobsCount;
import dev.tauri.jsg.stargate.rig.RIGEntity;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RIGWave
implements IJSONConfigEntry {
    private final String name;
    public int weight;
    public int chevronsToDial;
    public List<String> allowedOnGates;
    public List<String> allowedInDims;
    public List<Difficulty> allowedForDifficulties;
    public List<RIGEntity> entities;
    public boolean selectRandomMobs;
    @Nullable
    public MobsCount randomMobsCount;
    private boolean finished = false;
    private LinkedList<RIGEntity> currentPool = new LinkedList();

    public RIGWave(String name, int weight, List<String> allowedOnGates, List<String> allowedInDims, List<Difficulty> allowedForDifficulties, List<RIGEntity> entities) {
        this(name, weight, allowedOnGates, allowedInDims, allowedForDifficulties, entities, false, null);
    }

    public RIGWave(String name, int weight, List<String> allowedOnGates, List<String> allowedInDims, List<Difficulty> allowedForDifficulties, List<RIGEntity> entities, boolean selectRandomMobs, MobsCount randomMobsCount) {
        this.name = name;
        this.weight = weight;
        this.chevronsToDial = 7;
        this.allowedOnGates = allowedOnGates;
        this.allowedInDims = allowedInDims;
        this.allowedForDifficulties = allowedForDifficulties;
        this.entities = entities;
        this.selectRandomMobs = selectRandomMobs;
        this.randomMobsCount = randomMobsCount;
    }

    @Override
    public String getId() {
        return this.name;
    }

    public boolean hasFinished() {
        return this.finished;
    }

    public void setup(RandomSource random) {
        this.finished = false;
        this.currentPool = new LinkedList();
        if (!this.selectRandomMobs) {
            for (RIGEntity e : this.entities) {
                for (int i = 0; i < e.weight; ++i) {
                    this.currentPool.addLast(e);
                }
            }
        } else if (this.randomMobsCount != null) {
            LinkedList<RIGEntity> all = new LinkedList<RIGEntity>();
            for (RIGEntity e : this.entities) {
                for (int i = 0; i < e.weight; ++i) {
                    all.addLast(e);
                }
            }
            if (all.isEmpty()) {
                this.finished = true;
            } else {
                int count = this.randomMobsCount.get(random);
                for (int i = 0; i < count; ++i) {
                    int index = random.m_188503_(all.size());
                    this.currentPool.addLast((RIGEntity)all.get(index));
                }
            }
        }
        if (this.currentPool.isEmpty()) {
            this.finished = true;
        }
    }

    @NotNull
    public Entity getNextEntity(ServerLevel level) {
        if (this.hasFinished()) {
            throw new UnsupportedOperationException("Tried to get next entity when wave has already finished!");
        }
        RIGEntity entity = this.currentPool.getFirst();
        this.currentPool.removeFirst();
        if (this.currentPool.isEmpty()) {
            this.finished = true;
        }
        return entity.get(level);
    }
}

