/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.rig;

import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.config.JSGConfig;
import dev.tauri.jsg.config.stargate.StargateRIGConfig;
import dev.tauri.jsg.stargate.rig.RIGInstance;
import dev.tauri.jsg.stargate.rig.RIGWave;
import java.util.Collection;
import java.util.LinkedList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;

public class StargateRIGManager {
    public final StargateAbstractBaseBE gate;
    public final LinkedList<RIGWave> waves = new LinkedList();
    private RIGInstance rigInstance;

    public StargateRIGManager(StargateAbstractBaseBE gate) {
        this.gate = gate;
        this.init();
    }

    private void init() {
        this.waves.clear();
        Collection configWaves = StargateRIGConfig.INSTANCE.configEntries.values();
        for (RIGWave wave : configWaves) {
            if (!wave.allowedOnGates.contains(this.gate.getStargateType().toString())) continue;
            for (int i = 0; i < wave.weight; ++i) {
                this.waves.addLast(wave);
            }
        }
    }

    public boolean isActive() {
        return this.rigInstance != null && this.rigInstance.isRunning();
    }

    public boolean canStart() {
        if (this.rigInstance != null) {
            return false;
        }
        if (this.waves.isEmpty()) {
            return false;
        }
        Level level = this.gate.m_58904_();
        if (level == null) {
            return false;
        }
        if (!this.gate.isRIGAllowed()) {
            return false;
        }
        return this.gate.isMerged();
    }

    public void tick(boolean server) {
        if (!server) {
            return;
        }
        if (this.gate.m_58904_() == null) {
            return;
        }
        if (this.rigInstance == null) {
            RandomSource rand;
            if (this.gate.getLevelNotNull().m_46467_() % 40L == 0L && (double)(rand = this.gate.getLevelNotNull().m_213780_()).m_188501_() < (double)0.005f * (Double)JSGConfig.Stargate.rigChance.get() && this.canStart()) {
                this.generateNewIncoming();
            }
            return;
        }
        if (this.rigInstance.isRunning()) {
            this.rigInstance.tick();
        } else {
            this.rigInstance = null;
        }
    }

    public void generateNewIncoming() {
        RIGWave wave2;
        LinkedList<RIGWave> allowedWaves = new LinkedList<RIGWave>();
        for (RIGWave wave2 : this.waves) {
            if (!wave2.allowedInDims.contains(this.gate.getLevelNotNull().m_46472_().m_135782_().toString()) || !wave2.allowedForDifficulties.contains(this.gate.getLevelNotNull().m_46791_())) continue;
            allowedWaves.addLast(wave2);
        }
        if (allowedWaves.isEmpty()) {
            return;
        }
        RandomSource random = this.gate.getLevelNotNull().m_213780_();
        wave2 = (RIGWave)allowedWaves.get(random.m_188503_(allowedWaves.size()));
        wave2.setup(random);
        if (wave2.hasFinished()) {
            return;
        }
        int chevronCount = wave2.chevronsToDial;
        if (chevronCount > 9) {
            chevronCount = 9;
        }
        if (chevronCount < 7) {
            chevronCount = 7;
        }
        double animationLength = ((double)random.m_188503_(100) + 100.0) / 7.0 * (double)chevronCount;
        this.rigInstance = new RIGInstance(this, wave2, chevronCount, (int)animationLength);
    }

    public void onUnload() {
        if (this.rigInstance == null) {
            return;
        }
        this.rigInstance.end();
    }
}

