/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.teleportation;

import dev.tauri.jsg.advancements.JSGAdvancements;
import dev.tauri.jsg.api.event.StargateTeleportEntityEvent;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.config.JSGConfig;
import dev.tauri.jsg.helpers.BlockPosHelper;
import dev.tauri.jsg.packet.JSGPacketHandler;
import dev.tauri.jsg.packet.packets.stargate.StargateMotionToClient;
import dev.tauri.jsg.property.JSGProperties;
import dev.tauri.jsg.sound.JSGSoundHelper;
import dev.tauri.jsg.sound.SoundEventEnum;
import dev.tauri.jsg.stargate.network.StargatePos;
import dev.tauri.jsg.stargate.teleportation.TeleportHelper;
import dev.tauri.jsg.stargate.teleportation.TeleportPacket;
import dev.tauri.jsg.util.JSGAxisAlignedBB;
import dev.tauri.jsg.util.vectors.Vector3f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EventHorizon {
    private final Level world;
    private final BlockPos pos;
    private final BlockPos gateCenter;
    private final JSGAxisAlignedBB localBox;
    private final JSGAxisAlignedBB globalBox;
    private final JSGAxisAlignedBB globalBoxInFront;
    private final JSGAxisAlignedBB globalBoxBehind;
    private final Map<Integer, TeleportPacket> scheduledTeleportMap = new HashMap<Integer, TeleportPacket>();
    private final Map<Integer, Integer> timeoutMap = new HashMap<Integer, Integer>();
    private List<Entity> entitiesInFrontOfTheGate = new ArrayList<Entity>();

    public EventHorizon(Level world, BlockPos pos, BlockPos gateCenter, Direction facing, Direction verticalFacing, JSGAxisAlignedBB localBox) {
        this.world = world;
        this.pos = pos;
        this.gateCenter = gateCenter;
        Vec3 offset = new Vec3(0.5, 0.0, 0.5);
        if (verticalFacing != Direction.SOUTH && verticalFacing != null && facing != null) {
            offset = facing.m_122434_() == Direction.Axis.Z ? new Vec3(0.5, 0.5, (double)(facing.m_122431_() > 0 == verticalFacing.m_122430_() > 0 ? 1 : 0)) : new Vec3((double)(facing.m_122429_() > 0 == verticalFacing.m_122430_() > 0 ? 1 : 0), 0.5, 0.5);
        }
        localBox = localBox.rotate(facing, verticalFacing).offset(offset);
        Vec3 facingNormal = BlockPosHelper.getVec3(verticalFacing == Direction.SOUTH || verticalFacing == null ? facing.m_122436_() : verticalFacing.m_122436_());
        this.localBox = localBox;
        this.globalBox = this.localBox.offset(pos);
        this.globalBoxInFront = this.globalBox.offset(facingNormal.m_82542_((double)0.8f, (double)0.8f, (double)0.8f)).grow(facingNormal.m_82542_((double)0.4f, (double)0.4f, (double)0.4f));
        this.globalBoxBehind = this.globalBox.offset(facingNormal.m_82542_((double)-0.8f, (double)-0.8f, (double)-0.8f)).grow(facingNormal.m_82542_((double)0.4f, (double)0.4f, (double)0.4f));
    }

    public void reset() {
        this.scheduledTeleportMap.clear();
    }

    public JSGAxisAlignedBB getLocalBox() {
        return this.localBox;
    }

    private void mapEntitiesSubTick(List<Entity> list) {
        List entitiesBehindTheGate = this.world.m_45933_(null, (AABB)this.globalBoxBehind);
        for (Entity entity1 : entitiesBehindTheGate) {
            for (Entity entity2 : this.entitiesInFrontOfTheGate) {
                if (entity1.m_19879_() != entity2.m_19879_() || !entity1.m_6084_() || !entity2.m_6084_() || list.contains(entity1)) continue;
                list.add(entity1);
            }
        }
        this.entitiesInFrontOfTheGate = this.world.m_45933_(null, (AABB)this.globalBoxInFront);
    }

    public void scheduleTeleportation(StargatePos targetGate, boolean teleport) {
        if (targetGate == null) {
            return;
        }
        boolean closedIris = false;
        if (this.world.m_7702_(this.pos) instanceof StargateClassicBaseBE && ((StargateClassicBaseBE)Objects.requireNonNull(this.world.m_7702_(this.pos))).isIrisClosed()) {
            teleport = false;
            closedIris = true;
        }
        List entities = this.world.m_45933_(null, (AABB)this.globalBox);
        this.mapEntitiesSubTick(entities);
        if (teleport) {
            this.timeoutMap.replaceAll((i, v) -> this.timeoutMap.get(i) - 1);
            this.timeoutMap.entrySet().removeIf(entry -> (Integer)entry.getValue() < 0);
        }
        StargateAbstractBaseBE gateTile = (StargateAbstractBaseBE)this.world.m_7702_(this.pos);
        for (Entity entity : entities) {
            int entityId = entity.m_19879_();
            if (this.scheduledTeleportMap.containsKey(entityId) || this.timeoutMap.containsKey(entityId) || entity.m_20159_()) continue;
            Direction sourceFacing = (Direction)this.world.m_8055_(this.pos).m_61143_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY);
            Direction facingVertical = JSGProperties.getDirectionByVerticalFacing((Integer)this.world.m_8055_(this.pos).m_61143_((Property)JSGProperties.FACING_VERTICAL_PROPERTY));
            TeleportPacket packet = new TeleportPacket(entity, this.pos, targetGate);
            if (teleport && entity instanceof ServerPlayer) {
                this.scheduledTeleportMap.put(entityId, packet);
                JSGPacketHandler.sendTo(new StargateMotionToClient(this.pos), (ServerPlayer)entity);
                continue;
            }
            Vector3f motion = new Vector3f(entity.m_20184_());
            boolean front = TeleportHelper.frontSide(facingVertical == null ? sourceFacing : facingVertical, motion);
            if (!closedIris && teleport && front) {
                for (Entity passenger : entity.m_20197_()) {
                    this.timeoutMap.put(passenger.m_19879_(), 40);
                }
                this.timeoutMap.put(entityId, 40);
                this.scheduledTeleportMap.put(entityId, packet.setMotion(motion));
                this.teleportEntity(entityId);
                continue;
            }
            if (gateTile != null && gateTile.entitiesPassedLast.containsKey(entityId) || closedIris || teleport || !front || !((Boolean)JSGConfig.Stargate.wrongSideKilling.get()).booleanValue()) continue;
            TeleportHelper.wrongSideKill(entity);
        }
    }

    public void teleportEntity(int entityId) {
        TeleportPacket packet = this.scheduledTeleportMap.get(entityId);
        StargateAbstractBaseBE baseTile = (StargateAbstractBaseBE)this.world.m_7702_(this.pos);
        if (!new StargateTeleportEntityEvent(baseTile, packet.getTargetGatePos().getBlockEntity(), packet.getEntity()).post()) {
            JSGSoundHelper.playSoundEvent(this.world, this.gateCenter, SoundEventEnum.WORMHOLE_GO);
            if (baseTile != null && baseTile.isCurrentlyUnstable) {
                if (Math.random() < (Double)JSGConfig.Stargate.ehDeathChance.get()) {
                    TeleportHelper.unstableEhKill(packet.getEntity());
                } else {
                    packet.teleport();
                    if (packet.getEntity() instanceof ServerPlayer) {
                        JSGAdvancements.UNSTABLE_SURVIVE.trigger((ServerPlayer)packet.getEntity());
                    }
                }
            } else {
                packet.teleport();
            }
        }
        this.scheduledTeleportMap.remove(entityId);
    }

    public void removeEntity(int entityId) {
        this.scheduledTeleportMap.remove(entityId);
    }

    public void setMotion(int entityId, Vector3f motionVector) {
        this.scheduledTeleportMap.get(entityId).setMotion(motionVector);
    }
}

