/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.stargate.teleportation;

import dev.tauri.jsg.advancements.JSGAdvancements;
import dev.tauri.jsg.sound.JSGSoundHelper;
import dev.tauri.jsg.sound.SoundEventEnum;
import dev.tauri.jsg.stargate.network.StargatePos;
import dev.tauri.jsg.stargate.teleportation.TeleportHelper;
import dev.tauri.jsg.util.vectors.Vector3f;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class TeleportPacket {
    private final BlockPos sourceGatePos;
    private final StargatePos targetGatePos;
    private final Entity entity;
    private Vector3f motionVector;

    public TeleportPacket(Entity entity, BlockPos source, StargatePos target) {
        this.entity = entity;
        this.sourceGatePos = source;
        this.targetGatePos = target;
    }

    public StargatePos getTargetGatePos() {
        return this.targetGatePos;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void teleport() {
        this.teleport(true);
    }

    public void teleport(boolean playSound) {
        Entity entity = this.entity;
        if (entity instanceof ServerPlayer) {
            ServerPlayer p = (ServerPlayer)entity;
            JSGAdvancements.WORMHOLE_GO.trigger(p);
        }
        TeleportHelper.teleportEntity(this.entity, this.sourceGatePos, this.targetGatePos, this.motionVector);
        if (playSound) {
            JSGSoundHelper.playSoundEvent(this.targetGatePos.getWorld(), this.targetGatePos.getBlockEntity().getGateCenterPos(), SoundEventEnum.WORMHOLE_GO);
        }
    }

    public TeleportPacket setMotion(Vector3f motion) {
        this.motionVector = motion;
        return this;
    }
}

