/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lucent.core;

import com.legacy.lucent.api.plugin.ILucentPlugin;
import com.legacy.lucent.api.plugin.LucentPlugin;
import com.legacy.lucent.api.registry.LightLevelProviderRegistry;
import com.legacy.lucent.core.LucentConfig;
import com.legacy.lucent.core.LucentMod;
import com.legacy.lucent.core.LucentRegistry;
import com.legacy.lucent.core.PluginManager;
import com.legacy.lucent.core.asm_hooks.ChunkRenderDispatcherHooks;
import com.legacy.lucent.core.data.managers.LucentAssets;
import com.legacy.lucent.core.dynamic_lighting.DynamicLightingEngine;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.SectionPos;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class LucentClient {
    private static PluginManager<ILucentPlugin> plugins = null;

    public static void init() {
        plugins = new PluginManager<ILucentPlugin>(ILucentPlugin.class, LucentPlugin.class, LucentMod.LOGGER::getLogger, () -> "lucent");
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)LucentConfig.CLIENT_SPEC);
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.register(LucentConfig.ClientConfig.class);
        modBus.addListener(LucentClient::loadComplete);
        modBus.addListener(LucentAssets::registerListeners);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(LucentClient::onLogin);
        forgeBus.addListener(LucentClient::clientTick);
    }

    public static List<ILucentPlugin> getPlugins() {
        return plugins.get();
    }

    public static PluginManager<ILucentPlugin> pluginManager() {
        return plugins;
    }

    protected static void loadComplete(FMLLoadCompleteEvent event) {
        DynamicLightingEngine.start();
        event.enqueueWork(() -> {
            LightLevelProviderRegistry provRegistry = new LightLevelProviderRegistry();
            plugins.forEach(p -> p.registerLightLevelProviderTypes(provRegistry));
        });
    }

    protected static void onLogin(ClientPlayerNetworkEvent.LoggingIn event) {
        LucentRegistry.registerData();
        ChunkRenderDispatcherHooks.clear();
        LucentConfig.detectEnvironment();
    }

    protected static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            DynamicLightingEngine.clearForcedLights();
            DynamicLightingEngine.tickDeepDark();
        }
    }

    public static void setDirty(SectionPos section) {
        Minecraft.m_91087_().f_91060_.m_109770_(section.m_123341_(), section.m_123342_(), section.m_123343_());
        plugins.forEach(p -> p.onSectionMarkedDirty(section));
    }
}

