/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.content.network.transmitter;

import com.jerry.mekanism_extras.common.capabilities.heat.ExtraVariableHeatCapacitor;
import com.jerry.mekanism_extras.common.content.network.transmitter.IExtraUpgradeableTransmitter;
import com.jerry.mekanism_extras.common.tier.transmitter.TCTier;
import java.util.Collections;
import java.util.List;
import java.util.function.DoubleSupplier;
import mekanism.api.DataHandlerUtils;
import mekanism.api.IContentsListener;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.heat.IHeatHandler;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.heat.CachedAmbientTemperature;
import mekanism.common.content.network.transmitter.ThermodynamicConductor;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.lib.transmitter.acceptor.AcceptorCache;
import mekanism.common.tier.ConductorTier;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.upgrade.transmitter.ThermodynamicConductorUpgradeData;
import mekanism.common.upgrade.transmitter.TransmitterUpgradeData;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraThermodynamicConductor
extends ThermodynamicConductor
implements IExtraUpgradeableTransmitter<ThermodynamicConductorUpgradeData> {
    private final CachedAmbientTemperature ambientTemperature = new CachedAmbientTemperature(() -> ((ExtraThermodynamicConductor)this).getTileWorld(), () -> ((ExtraThermodynamicConductor)this).getTilePos());
    public final ConductorTier tier;
    private final List<IHeatCapacitor> capacitors;
    public final ExtraVariableHeatCapacitor buffer;
    private double clientTemperature = -1.0;

    public ExtraThermodynamicConductor(IBlockProvider blockProvider, TileEntityTransmitter tile) {
        super(blockProvider, tile);
        this.tier = (ConductorTier)Attribute.getTier((IBlockProvider)blockProvider, ConductorTier.class);
        this.buffer = ExtraVariableHeatCapacitor.create(TCTier.getHeatCapacity(this.tier), TCTier.getConduction(this.tier), TCTier.getConductionInsulation(this.tier), (DoubleSupplier)this.ambientTemperature, (IContentsListener)this);
        this.capacitors = Collections.singletonList(this.buffer);
    }

    public AcceptorCache<IHeatHandler> getAcceptorCache() {
        return super.getAcceptorCache();
    }

    public boolean isValidAcceptor(BlockEntity tile, Direction side) {
        return this.getAcceptorCache().isAcceptorAndListen(tile, side, Capabilities.HEAT_HANDLER);
    }

    @NotNull
    public CompoundTag write(@NotNull CompoundTag tag) {
        super.write(tag);
        tag.m_128365_("HeatCapacitors", (Tag)DataHandlerUtils.writeContainers(this.getHeatCapacitors(null)));
        return tag;
    }

    public void read(@NotNull CompoundTag tag) {
        super.read(tag);
        DataHandlerUtils.readContainers(this.getHeatCapacitors(null), (ListTag)tag.m_128437_("HeatCapacitors", 10));
    }

    @NotNull
    public CompoundTag getReducedUpdateTag(CompoundTag updateTag) {
        updateTag = super.getReducedUpdateTag(updateTag);
        updateTag.m_128347_("temperature", this.buffer.getHeat());
        return updateTag;
    }

    @NotNull
    public List<IHeatCapacitor> getHeatCapacitors(Direction side) {
        return this.capacitors;
    }

    public void handleUpdateTag(@NotNull CompoundTag tag) {
        super.handleUpdateTag(tag);
        NBTUtils.setDoubleIfPresent((CompoundTag)tag, (String)"temperature", arg_0 -> ((ExtraVariableHeatCapacitor)this.buffer).setHeat(arg_0));
    }

    public void onContentsChanged() {
        if (!this.isRemote()) {
            if (this.clientTemperature == -1.0) {
                this.clientTemperature = this.ambientTemperature.getAsDouble();
            }
            if (Math.abs(this.buffer.getTemperature() - this.clientTemperature) > this.buffer.getTemperature() / 20.0) {
                this.clientTemperature = this.buffer.getTemperature();
                this.getTransmitterTile().sendUpdatePacket();
            }
        }
        this.getTransmitterTile().m_6596_();
    }

    public double getAmbientTemperature(@NotNull Direction side) {
        return this.ambientTemperature.getTemperature(side);
    }

    @Nullable
    public IHeatHandler getAdjacent(@NotNull Direction side) {
        if (ExtraThermodynamicConductor.connectionMapContainsSide((byte)this.getAllCurrentConnections(), (Direction)side)) {
            return this.getAcceptorCache().getConnectedAcceptor(side).resolve().orElse(null);
        }
        return null;
    }

    public double incrementAdjacentTransfer(double currentAdjacentTransfer, double tempToTransfer, @NotNull Direction side) {
        TileEntityTransmitter transmitter;
        BlockEntity sink;
        if (tempToTransfer > 0.0 && (sink = this.getAcceptorCache().getConnectedAcceptorTile(side)) instanceof TileEntityTransmitter && TransmissionType.HEAT.checkTransmissionType(transmitter = (TileEntityTransmitter)sink)) {
            return currentAdjacentTransfer;
        }
        return super.incrementAdjacentTransfer(currentAdjacentTransfer, tempToTransfer, side);
    }

    @Override
    @Nullable
    public ThermodynamicConductorUpgradeData getUpgradeData() {
        return super.getUpgradeData();
    }

    @Override
    public boolean dataTypeMatches(@NotNull TransmitterUpgradeData data) {
        return super.dataTypeMatches(data);
    }

    @Override
    public void parseUpgradeData(@NotNull ThermodynamicConductorUpgradeData data) {
        super.parseUpgradeData(data);
    }
}

