/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.tile.transmitter;

import com.jerry.mekanism_extras.api.tier.AdvancedTier;
import com.jerry.mekanism_extras.common.content.network.transmitter.ExtraMechanicalPipe;
import com.jerry.mekanism_extras.common.registry.ExtraBlock;
import com.jerry.mekanism_extras.common.tile.transmitter.ExtraTileEntityTransmitter;
import java.util.Collections;
import java.util.List;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.ISidedFluidHandler;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.block.states.TransmitterType;
import mekanism.common.capabilities.fluid.DynamicFluidHandler;
import mekanism.common.capabilities.resolver.ICapabilityResolver;
import mekanism.common.capabilities.resolver.manager.FluidHandlerManager;
import mekanism.common.content.network.FluidNetwork;
import mekanism.common.integration.computer.ComputerCapabilityHelper;
import mekanism.common.integration.computer.IComputerTile;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraTileEntityMechanicalPipe
extends ExtraTileEntityTransmitter
implements IComputerTile {
    private final FluidHandlerManager fluidHandlerManager = new FluidHandlerManager(direction -> {
        ExtraMechanicalPipe pipe = this.getTransmitter();
        if (direction != null && pipe.getConnectionTypeRaw(direction) == ConnectionType.NONE || pipe.isRedstoneActivated()) {
            return Collections.emptyList();
        }
        return pipe.getFluidTanks(direction);
    }, (ISidedFluidHandler)new DynamicFluidHandler(this::getFluidTanks, this.getExtractPredicate(), this.getInsertPredicate(), null));

    public ExtraTileEntityMechanicalPipe(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
        this.addCapabilityResolver((ICapabilityResolver)this.fluidHandlerManager);
        ComputerCapabilityHelper.addComputerCapabilities((BlockEntity)this, x$0 -> this.addCapabilityResolver((ICapabilityResolver)x$0));
    }

    protected ExtraMechanicalPipe createTransmitter(IBlockProvider blockProvider) {
        return new ExtraMechanicalPipe(blockProvider, this);
    }

    public ExtraMechanicalPipe getTransmitter() {
        return (ExtraMechanicalPipe)super.getTransmitter();
    }

    protected void onUpdateServer() {
        this.getTransmitter().pullFromAcceptors();
        super.onUpdateServer();
    }

    public TransmitterType getTransmitterType() {
        return TransmitterType.MECHANICAL_PIPE;
    }

    @Override
    @NotNull
    protected BlockState upgradeResult(@NotNull BlockState current, @NotNull AdvancedTier tier) {
        return BlockStateHelper.copyStateData((BlockState)current, switch (tier) {
            case AdvancedTier.ABSOLUTE -> ExtraBlock.ABSOLUTE_MECHANICAL_PIPE;
            case AdvancedTier.SUPREME -> ExtraBlock.SUPREME_MECHANICAL_PIPE;
            case AdvancedTier.COSMIC -> ExtraBlock.COSMIC_MECHANICAL_PIPE;
            case AdvancedTier.INFINITE -> ExtraBlock.INFINITE_MECHANICAL_PIPE;
            default -> null;
        });
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag updateTag = super.m_5995_();
        if (this.getTransmitter().hasTransmitterNetwork()) {
            FluidNetwork network = (FluidNetwork)this.getTransmitter().getTransmitterNetwork();
            updateTag.m_128365_("fluid", (Tag)network.lastFluid.writeToNBT(new CompoundTag()));
            updateTag.m_128350_("scale", network.currentScale);
        }
        return updateTag;
    }

    private List<IExtendedFluidTank> getFluidTanks(@Nullable Direction side) {
        return this.fluidHandlerManager.getContainers(side);
    }

    public void sideChanged(@NotNull Direction side, @NotNull ConnectionType old, @NotNull ConnectionType type) {
        super.sideChanged(side, old, type);
        if (type == ConnectionType.NONE) {
            this.invalidateCapability(ForgeCapabilities.FLUID_HANDLER, side);
            WorldUtils.notifyNeighborOfChange((Level)this.f_58857_, (Direction)side, (BlockPos)this.f_58858_);
        } else if (old == ConnectionType.NONE) {
            WorldUtils.notifyNeighborOfChange((Level)this.f_58857_, (Direction)side, (BlockPos)this.f_58858_);
        }
    }

    public void redstoneChanged(boolean powered) {
        super.redstoneChanged(powered);
        if (powered) {
            this.invalidateCapability(ForgeCapabilities.FLUID_HANDLER, EnumUtils.DIRECTIONS);
        }
    }

    public String getComputerName() {
        return this.getTransmitter().getTier().getBaseTier().getLowerName() + "MechanicalPipe";
    }

    @ComputerMethod
    FluidStack getBuffer() {
        return this.getTransmitter().getBufferWithFallback();
    }

    @ComputerMethod
    long getCapacity() {
        ExtraMechanicalPipe pipe = this.getTransmitter();
        return pipe.hasTransmitterNetwork() ? ((FluidNetwork)pipe.getTransmitterNetwork()).getCapacity() : pipe.getCapacity();
    }

    @ComputerMethod
    long getNeeded() {
        return this.getCapacity() - (long)this.getBuffer().getAmount();
    }

    @ComputerMethod
    double getFilledPercentage() {
        return (double)this.getBuffer().getAmount() / (double)this.getCapacity();
    }
}

