/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.item;

import dev.su5ed.mffs.api.card.FrequencyCard;
import dev.su5ed.mffs.item.BaseItem;
import dev.su5ed.mffs.setup.ModCapabilities;
import dev.su5ed.mffs.util.ModUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class FrequencyCardItem
extends BaseItem {
    private static final int MAX_FREQUENCY = 999999;

    public FrequencyCardItem() {
        super(new BaseItem.ExtendedItemProperties(new Item.Properties().m_41487_(1)).description());
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new FrequencyCardCapability();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        if (player.m_6144_()) {
            ItemStack stack = player.m_21120_(usedHand);
            return stack.getCapability(ModCapabilities.FREQUENCY_CARD).map(card -> {
                if (!level.f_46443_) {
                    int frequency = level.f_46441_.m_188503_(1000000);
                    card.setFrequency(frequency);
                    player.m_5661_((Component)ModUtil.translate("info", "frequency.generated", Component.m_237113_((String)String.valueOf(frequency)).m_130940_(ChatFormatting.AQUA)), true);
                }
                return InteractionResultHolder.m_19096_((Object)stack);
            }).orElseGet(() -> InteractionResultHolder.m_19098_((Object)stack));
        }
        return super.m_7203_(level, player, usedHand);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level level = context.m_43725_();
        return Optional.ofNullable(level.m_7702_(context.m_8083_())).flatMap(be -> be.getCapability(ModCapabilities.FORTRON).resolve()).map(fortron -> {
            if (!level.f_46443_) {
                int frequency = (Integer)stack.getCapability(ModCapabilities.FREQUENCY_CARD).map(FrequencyCard::getFrequency).orElseThrow();
                fortron.setFrequency(frequency);
                context.m_43723_().m_5661_((Component)ModUtil.translate("info", "frequency.set", Component.m_237113_((String)String.valueOf(frequency)).m_130940_(ChatFormatting.GREEN)), true);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }).orElse(InteractionResult.PASS);
    }

    @Override
    public void appendHoverTextPre(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.appendHoverTextPre(stack, level, tooltipComponents, isAdvanced);
        stack.getCapability(ModCapabilities.FREQUENCY_CARD).map(FrequencyCard::getFrequency).ifPresent(frequency -> tooltipComponents.add((Component)ModUtil.translate("info", "frequency", Component.m_237113_((String)String.valueOf(frequency)).m_130940_(ChatFormatting.GREEN)).m_130940_(ChatFormatting.DARK_GRAY)));
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        INBTSerializable card = (INBTSerializable)stack.getCapability(ModCapabilities.FREQUENCY_CARD).resolve().orElseThrow();
        tag.m_128365_("card_capability", card.serializeNBT());
        return tag;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag tag) {
        super.readShareTag(stack, tag);
        if (tag != null) {
            stack.getCapability(ModCapabilities.FREQUENCY_CARD).ifPresent(card -> {
                CompoundTag cardTag = tag.m_128469_("card_capability");
                card.deserializeNBT((Tag)cardTag);
            });
        }
    }

    public static class FrequencyCardCapability
    implements ICapabilityProvider,
    FrequencyCard {
        private final LazyOptional<FrequencyCard> optional = LazyOptional.of(() -> this);
        private int frequency;

        public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
            return ModCapabilities.FREQUENCY_CARD.orEmpty(cap, this.optional);
        }

        @Override
        public int getFrequency() {
            return this.frequency;
        }

        @Override
        public void setFrequency(int frequency) {
            this.frequency = frequency;
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("frequency", this.frequency);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            this.frequency = tag.m_128451_("frequency");
        }
    }
}

