/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.item;

import com.mojang.authlib.GameProfile;
import dev.su5ed.mffs.api.card.IdentificationCard;
import dev.su5ed.mffs.api.security.FieldPermission;
import dev.su5ed.mffs.item.BaseItem;
import dev.su5ed.mffs.setup.ModCapabilities;
import dev.su5ed.mffs.util.ModUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdentificationCardItem
extends BaseItem {
    public IdentificationCardItem() {
        super(new BaseItem.ExtendedItemProperties(new Item.Properties().m_41487_(1)).description());
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new IdentificationCardCapability();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        if (player.m_6144_()) {
            ItemStack stack = player.m_21120_(usedHand);
            return stack.getCapability(ModCapabilities.IDENTIFICATION_CARD).map(card -> {
                if (!level.f_46443_) {
                    if (card.getIdentity() != null) {
                        card.setIdentity(null);
                        player.m_5661_((Component)ModUtil.translate("info", "identity_cleared", new Object[0]), true);
                    } else {
                        IdentificationCardItem.setCardIdentity(card, player, player.m_36316_());
                    }
                }
                return InteractionResultHolder.m_19096_((Object)player.m_21120_(usedHand));
            }).orElseGet(() -> InteractionResultHolder.m_19098_((Object)stack));
        }
        return super.m_7203_(level, player, usedHand);
    }

    public static void onLivingEntityInteract(PlayerInteractEvent.EntityInteract event) {
        ItemStack stack = event.getItemStack();
        Player player = event.getEntity();
        Entity target = event.getTarget();
        if (player.m_6144_() && target instanceof Player) {
            Player targetPlayer = (Player)target;
            stack.getCapability(ModCapabilities.IDENTIFICATION_CARD).ifPresent(card -> {
                if (!player.m_9236_().f_46443_) {
                    IdentificationCardItem.setCardIdentity(card, player, targetPlayer.m_36316_());
                }
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.m_19078_((boolean)player.m_9236_().f_46443_));
            });
        }
    }

    private static void setCardIdentity(IdentificationCard card, Player user, GameProfile profile) {
        card.setIdentity(profile);
        user.m_5661_((Component)ModUtil.translate("info", "identity_set", Component.m_237113_((String)profile.getName()).m_130940_(ChatFormatting.GREEN)), true);
    }

    @Override
    protected void appendHoverTextPre(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.appendHoverTextPre(stack, level, tooltipComponents, isAdvanced);
        stack.getCapability(ModCapabilities.IDENTIFICATION_CARD).ifPresent(card -> {
            List<FieldPermission> perms;
            GameProfile identity = card.getIdentity();
            if (identity != null) {
                tooltipComponents.add((Component)ModUtil.translate("info", "identity", Component.m_237113_((String)identity.getName()).m_130940_(ChatFormatting.GREEN)).m_130940_(ChatFormatting.DARK_GRAY));
            }
            if (!(perms = List.copyOf(card.getPermissions())).isEmpty()) {
                MutableComponent permsComponent = ModUtil.translate(perms.get(0));
                for (int i = 1; i < perms.size(); ++i) {
                    permsComponent.m_130946_(", ").m_7220_((Component)ModUtil.translate(perms.get(i)));
                }
                tooltipComponents.add((Component)permsComponent.m_130940_(ChatFormatting.DARK_GRAY));
            }
        });
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        INBTSerializable card = (INBTSerializable)stack.getCapability(ModCapabilities.IDENTIFICATION_CARD).resolve().orElseThrow();
        tag.m_128365_("card_capability", card.serializeNBT());
        return tag;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag tag) {
        super.readShareTag(stack, tag);
        if (tag != null) {
            stack.getCapability(ModCapabilities.IDENTIFICATION_CARD).ifPresent(card -> {
                CompoundTag cardTag = tag.m_128469_("card_capability");
                card.deserializeNBT((Tag)cardTag);
            });
        }
    }

    public static class IdentificationCardCapability
    implements ICapabilityProvider,
    IdentificationCard {
        private final LazyOptional<IdentificationCard> optional = LazyOptional.of(() -> this);
        private GameProfile profile;
        private final Set<FieldPermission> permissions = new HashSet<FieldPermission>();

        @Override
        public boolean hasPermission(FieldPermission permission) {
            return this.permissions.contains((Object)permission);
        }

        @Override
        public void addPermission(FieldPermission permission) {
            this.permissions.add(permission);
        }

        @Override
        public void removePermission(FieldPermission permission) {
            this.permissions.remove((Object)permission);
        }

        @Override
        public Collection<FieldPermission> getPermissions() {
            return this.permissions;
        }

        @Override
        public void setPermissions(Collection<FieldPermission> permissions) {
            this.permissions.clear();
            this.permissions.addAll(permissions);
        }

        @Override
        @Nullable
        public GameProfile getIdentity() {
            return this.profile;
        }

        @Override
        public void setIdentity(GameProfile profile) {
            this.profile = profile;
        }

        @Override
        public boolean checkIdentity(Player player) {
            return this.profile == null || player.m_36316_().equals((Object)this.profile);
        }

        @Override
        public void copyTo(IdentificationCard other) {
            other.setIdentity(this.getIdentity());
            other.setPermissions(this.getPermissions());
        }

        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
            return ModCapabilities.IDENTIFICATION_CARD.orEmpty(cap, this.optional);
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            if (this.profile != null) {
                tag.m_128365_("profile", (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)this.profile));
                ListTag permissionsTag = new ListTag();
                for (FieldPermission permission : this.permissions) {
                    permissionsTag.add((Object)StringTag.m_129297_((String)permission.name()));
                }
                tag.m_128365_("permissions", (Tag)permissionsTag);
            }
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128441_("profile")) {
                this.profile = NbtUtils.m_129228_((CompoundTag)tag.m_128469_("profile"));
                ListTag permissionsTag = tag.m_128437_("permissions", 8);
                for (Tag permTag : permissionsTag) {
                    FieldPermission permission = ModUtil.getEnumConstantSafely(FieldPermission.class, permTag.m_7916_());
                    if (permission == null) continue;
                    this.permissions.add(permission);
                }
            }
        }
    }
}

