/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.network;

import dev.su5ed.mffs.blockentity.ProjectorBlockEntity;
import dev.su5ed.mffs.network.DrawBeamPacket;
import dev.su5ed.mffs.network.DrawHologramPacket;
import dev.su5ed.mffs.network.Network;
import dev.su5ed.mffs.network.UpdateAnimationSpeed;
import dev.su5ed.mffs.network.UpdateBlockEntityPacket;
import dev.su5ed.mffs.render.particle.BeamParticleOptions;
import dev.su5ed.mffs.render.particle.MovingHologramParticleOptions;
import dev.su5ed.mffs.render.particle.ParticleColor;
import dev.su5ed.mffs.setup.ModObjects;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.Vec3;

public final class ClientPacketHandler {
    public static void handleDrawBeamPacket(DrawBeamPacket packet) {
        Minecraft minecraft = Minecraft.m_91087_();
        Vec3 pos = packet.position();
        minecraft.f_91073_.m_7106_((ParticleOptions)new BeamParticleOptions(packet.target(), packet.color(), packet.lifetime()), pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), 0.0, 0.0, 0.0);
    }

    public static void handleUpdateAnimationSpeedPacket(UpdateAnimationSpeed packet) {
        Network.findBlockEntity(ProjectorBlockEntity.class, (Level)Minecraft.m_91087_().f_91073_, packet.pos()).ifPresent(be -> be.setClientAnimationSpeed(packet.animationSpeed()));
    }

    public static void handleDrawHologramPacket(DrawHologramPacket packet) {
        Minecraft minecraft = Minecraft.m_91087_();
        DrawHologramPacket.Type type = packet.type();
        Vec3 pos = packet.pos().m_82520_(0.5, 0.5, 0.5);
        Vec3 target = packet.target();
        Vec3 targetCenter = packet.target().m_82520_(0.5, 0.5, 0.5);
        if (type == DrawHologramPacket.Type.CONSTRUCT) {
            minecraft.f_91073_.m_7106_((ParticleOptions)new BeamParticleOptions(targetCenter, ParticleColor.BLUE_BEAM, 40), pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), 0.0, 0.0, 0.0);
            minecraft.f_91073_.m_7106_((ParticleOptions)new MovingHologramParticleOptions(ParticleColor.BLUE_FIELD, 40), target.m_7096_(), target.m_7098_(), target.m_7094_(), 0.0, 0.0, 0.0);
        } else if (type == DrawHologramPacket.Type.DESTROY) {
            minecraft.f_91073_.m_7106_((ParticleOptions)new BeamParticleOptions(targetCenter, ParticleColor.RED, 40), pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), 0.0, 0.0, 0.0);
            minecraft.f_91073_.m_7106_((ParticleOptions)new MovingHologramParticleOptions(ParticleColor.RED, 40), target.m_7096_(), target.m_7098_(), target.m_7094_(), 0.0, 0.0, 0.0);
        }
    }

    public static void handleBlockEntityUpdatePacket(UpdateBlockEntityPacket packet) {
        Minecraft minecraft = Minecraft.m_91087_();
        minecraft.f_91073_.m_141902_(packet.pos(), (BlockEntityType)ModObjects.FORCE_FIELD_BLOCK_ENTITY.get()).ifPresent(be -> be.handleCustomUpdateTag(packet.data()));
    }

    private ClientPacketHandler() {
    }
}

