/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.util.inventory;

import dev.su5ed.mffs.util.inventory.InventorySlot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class InventorySlotItemHandler
implements IItemHandler,
IItemHandlerModifiable,
INBTSerializable<CompoundTag> {
    private final Runnable onChanged;
    private final List<InventorySlot> slots = new ArrayList<InventorySlot>();

    public InventorySlotItemHandler(Runnable onChanged) {
        this.onChanged = onChanged;
    }

    public InventorySlot addSlot(String name, InventorySlot.Mode mode, Predicate<ItemStack> filter) {
        return this.addSlot(name, mode, filter, stack -> {});
    }

    public InventorySlot addSlot(String name, InventorySlot.Mode mode, Predicate<ItemStack> filter, Consumer<ItemStack> onChanged) {
        return this.addSlot(name, mode, filter, onChanged, false);
    }

    public InventorySlot addSlot(String name, InventorySlot.Mode mode, Predicate<ItemStack> filter, Consumer<ItemStack> onChanged, boolean virtual) {
        InventorySlot slot = new InventorySlot(this, name, mode, filter, onChanged, virtual);
        this.slots.add(slot);
        return slot;
    }

    public void onChanged() {
        this.onChanged.run();
    }

    public Collection<ItemStack> getAllItems() {
        return ((StreamEx)((StreamEx)StreamEx.of(this.slots).remove(InventorySlot::isVirtual)).map(InventorySlot::getItem).remove(ItemStack::m_41619_)).toList();
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        this.validateSlotIndex(slot);
        this.slots.get(slot).setItem(stack);
    }

    public int getSlots() {
        return this.slots.size();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return this.slots.get(slot).getItem();
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        this.validateSlotIndex(slot);
        return this.slots.get(slot).insert(stack, simulate);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        this.validateSlotIndex(slot);
        return this.slots.get(slot).extract(amount, simulate);
    }

    public int getSlotLimit(int slot) {
        this.validateSlotIndex(slot);
        return 64;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        this.validateSlotIndex(slot);
        return this.slots.get(slot).accepts(stack);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        this.slots.forEach(slot -> {
            CompoundTag tag = new CompoundTag();
            slot.getItem().m_41739_(tag);
            nbt.m_128365_(slot.getName(), (Tag)tag);
        });
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.slots.forEach(slot -> {
            if (nbt.m_128441_(slot.getName())) {
                CompoundTag tag = nbt.m_128469_(slot.getName());
                slot.setItem(ItemStack.m_41712_((CompoundTag)tag), false);
            }
        });
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.slots.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.slots.size() + ")");
        }
    }
}

