/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.maid;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import dev.xkmc.modulargolems.content.config.GolemMaterial;
import dev.xkmc.modulargolems.content.config.GolemMaterialConfig;
import dev.xkmc.modulargolems.content.core.GolemType;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.metalgolem.MetalGolemPartType;
import dev.xkmc.modulargolems.content.item.golem.GolemHolder;
import dev.xkmc.modulargolems.init.registrate.GolemTypes;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class GolemHealUtils {
    private final EntityMaid owner;
    private final CombinedInvWrapper inv;
    private final Map<ResourceLocation, Integer> cache = new LinkedHashMap<ResourceLocation, Integer>();

    public GolemHealUtils(EntityMaid owner, CombinedInvWrapper inv) {
        this.owner = owner;
        this.inv = inv;
    }

    public boolean tryHealGolem(EntityMaid owner, AbstractGolemEntity<?, ?> golem) {
        ResourceLocation mat;
        int index;
        AbstractGolemEntity old;
        LivingEntity target;
        if (!this.shouldHeal(golem)) {
            return false;
        }
        Optional opt = owner.m_6274_().m_21952_(MemoryModuleType.f_26374_);
        if (opt.isPresent() && (target = (LivingEntity)opt.get()) instanceof AbstractGolemEntity && this.shouldHeal(old = (AbstractGolemEntity)target)) {
            return false;
        }
        if ((double)owner.m_20270_(golem) < 2.5 && (index = this.getIndexOfMaterial(mat = golem.getMaterials().get(MetalGolemPartType.BODY.ordinal()).id())) >= 0 && !this.inv.extractItem(index, 1, false).m_41619_()) {
            golem.repairWithItem();
            float f1 = 1.0f + (golem.m_217043_().m_188501_() - golem.m_217043_().m_188501_()) * 0.2f;
            golem.m_5496_(SoundEvents.f_12009_, 1.0f, f1);
            owner.m_6274_().m_21936_(MemoryModuleType.f_26374_);
            return true;
        }
        owner.m_6274_().m_21879_(MemoryModuleType.f_26374_, golem);
        return false;
    }

    public void tryFixGolem() {
        for (int slot = 0; slot < this.inv.getSlots(); ++slot) {
            int index;
            float heal;
            ItemStack stack = this.inv.getStackInSlot(slot);
            Item item = stack.m_41720_();
            if (!(item instanceof GolemHolder)) continue;
            GolemHolder holder = (GolemHolder)item;
            ArrayList<GolemMaterial> mats = GolemHolder.getMaterial(stack);
            GolemType type = holder.getEntityType();
            Object part = type.getBodyPart();
            if (mats.size() <= part.ordinal()) continue;
            ResourceLocation mat = mats.get(part.ordinal()).id();
            int reforge = GolemHolder.getReforge(stack);
            if (reforge > 0) {
                int index2 = this.getIndexOfMaterial(mat);
                if (index2 < 0 || this.inv.extractItem(index2, 1, false).m_41619_()) continue;
                GolemHolder.setReforge(stack, reforge - 1);
                this.inv.setStackInSlot(slot, stack);
                continue;
            }
            float max = GolemHolder.getMaxHealth(stack);
            float health = GolemHolder.getHealth(stack);
            if (health == -1.0f || (double)health > (double)max * 0.75 || (heal = holder.getInvHeal(stack, (Entity)this.owner)) > 0.0f || (index = this.getIndexOfMaterial(mat)) < 0 || this.inv.extractItem(index, 1, false).m_41619_()) continue;
            GolemHolder.setHealth(stack, Math.min(max, health + max / 4.0f));
            this.inv.setStackInSlot(slot, stack);
        }
    }

    private boolean shouldHeal(AbstractGolemEntity<?, ?> golem) {
        if (golem.m_6095_() != GolemTypes.ENTITY_GOLEM.get()) {
            return false;
        }
        if ((double)golem.m_21223_() > (double)golem.m_21233_() * 0.75 && !golem.isReforged()) {
            return false;
        }
        ResourceLocation mat = golem.getMaterials().get(MetalGolemPartType.BODY.ordinal()).id();
        return this.getIndexOfMaterial(mat) >= 0;
    }

    private int getIndexOfMaterial(ResourceLocation mat) {
        Ingredient ing = GolemMaterialConfig.get().getRepairIngredient(mat);
        Integer old = this.cache.get(mat);
        if (old != null) {
            if (old == -1) {
                return -1;
            }
            ItemStack item = this.inv.getStackInSlot(old.intValue());
            if (!item.m_41619_() && ing.test(item)) {
                return old;
            }
        }
        for (int i = 0; i < this.inv.getSlots(); ++i) {
            ItemStack item = this.inv.getStackInSlot(i);
            if (item.m_41619_() || !ing.test(item)) continue;
            this.cache.put(mat, i);
            return i;
        }
        this.cache.put(mat, -1);
        return -1;
    }
}

