/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.materials.create;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.tterrag.registrate.builders.NoConfigBuilder;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.xkmc.l2complements.init.data.TagGen;
import dev.xkmc.modulargolems.compat.materials.create.automation.DummyFurnace;
import dev.xkmc.modulargolems.compat.materials.create.modifier.CoatingModifier;
import dev.xkmc.modulargolems.compat.materials.create.modifier.MechBodyModifier;
import dev.xkmc.modulargolems.compat.materials.create.modifier.MechForceEffect;
import dev.xkmc.modulargolems.compat.materials.create.modifier.MechForceModifier;
import dev.xkmc.modulargolems.compat.materials.create.modifier.MechMobileEffect;
import dev.xkmc.modulargolems.compat.materials.create.modifier.MechMobileModifier;
import dev.xkmc.modulargolems.content.core.GolemStatType;
import dev.xkmc.modulargolems.content.item.upgrade.SimpleUpgradeItem;
import dev.xkmc.modulargolems.content.modifier.base.AttributeGolemModifier;
import dev.xkmc.modulargolems.init.ModularGolems;
import dev.xkmc.modulargolems.init.data.MGTagGen;
import dev.xkmc.modulargolems.init.registrate.GolemItems;
import dev.xkmc.modulargolems.init.registrate.GolemModifiers;
import dev.xkmc.modulargolems.init.registrate.GolemTypes;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.item.Item;
import net.minecraftforge.fml.ModList;

public class CreateCompatRegistry {
    public static final RegistryEntry<CoatingModifier> COATING;
    public static final RegistryEntry<AttributeGolemModifier> PUSH;
    public static final RegistryEntry<MechBodyModifier> BODY;
    public static final RegistryEntry<MechMobileModifier> MOBILE;
    public static final RegistryEntry<MechForceModifier> FORCE;
    public static final RegistryEntry<MechMobileEffect> EFF_MOBILE;
    public static final RegistryEntry<MechForceEffect> EFF_FORCE;
    public static final ItemEntry<SimpleUpgradeItem> UP_COATING;
    public static final ItemEntry<SimpleUpgradeItem> UP_PUSH;
    public static final ItemEntry<DummyFurnace> DUMMY;
    public static final TagKey<Item> CARDBOARD;

    private static <T extends MobEffect> RegistryEntry<T> genEffect(String name, NonNullSupplier<T> sup, String desc) {
        return ((NoConfigBuilder)ModularGolems.REGISTRATE.effect(name, sup, desc).lang(MobEffect::m_19481_)).register();
    }

    public static void register() {
        MGTagGen.OPTIONAL_ITEM.add(e -> e.addTag(CARDBOARD).m_176839_(new ResourceLocation("create", "cardboard")));
        MGTagGen.OPTIONAL_ITEM.add(e -> e.addTag(MGTagGen.SPECIAL_CRAFT).m_176839_(new ResourceLocation("create", "cardboard")).m_176839_(AllItems.ANDESITE_ALLOY.getId()).m_176841_(new ResourceLocation("forge", "ingots/brass")).m_176839_(AllBlocks.RAILWAY_CASING.getId()));
        if (ModList.get().isLoaded("l2complements")) {
            MGTagGen.OPTIONAL_EFF.add(e -> e.addTag(TagGen.SKILL_EFFECT).m_176839_(EFF_MOBILE.getId()).m_176839_(EFF_FORCE.getId()));
        }
    }

    static {
        CARDBOARD = ItemTags.create((ResourceLocation)ModularGolems.loc("cardboard"));
        COATING = GolemModifiers.reg("coating", CoatingModifier::new, "Reduce damage taken by %s");
        PUSH = GolemModifiers.reg("push", () -> new AttributeGolemModifier(1, new AttributeGolemModifier.AttrEntry((Supplier<GolemStatType>)GolemTypes.STAT_ATKKB, () -> 1.0))).register();
        BODY = GolemModifiers.reg("mechanical_engine", MechBodyModifier::new, "Consumes fuels to power the golem up.");
        MOBILE = GolemModifiers.reg("mechanical_mobility", MechMobileModifier::new, "When burning fuels, increase speed by %s%%");
        FORCE = GolemModifiers.reg("mechanical_force", MechForceModifier::new, "When burning fuels, increase attack damage by %s%%");
        UP_COATING = GolemItems.regModUpgrade("coating", () -> COATING, "create").lang("Zinc Upgrade").register();
        UP_PUSH = GolemItems.regModUpgrade("push", () -> PUSH, "create").lang("Extendo Upgrade").register();
        EFF_MOBILE = CreateCompatRegistry.genEffect("mechanical_mobility", () -> new MechMobileEffect(MobEffectCategory.BENEFICIAL, -1), "Increase golem movement speed");
        EFF_FORCE = CreateCompatRegistry.genEffect("mechanical_force", () -> new MechForceEffect(MobEffectCategory.BENEFICIAL, -1), "Increase golem attack damage");
        DUMMY = ModularGolems.REGISTRATE.item("dummy_furnace", p -> new DummyFurnace()).model((ctx, pvd) -> pvd.withExistingParent("item/" + ctx.getName(), "block/air")).removeTab(GolemItems.ITEMS.getKey()).register();
    }
}

