/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.materials.create.automation;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.kinetics.deployer.DeployerApplicationRecipe;
import com.simibubi.create.content.kinetics.press.PressingRecipe;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import dev.xkmc.modulargolems.compat.materials.common.CompatManager;
import dev.xkmc.modulargolems.compat.materials.create.automation.ConditionalSARecipeBuilder;
import dev.xkmc.modulargolems.content.item.golem.GolemPart;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.registries.ForgeRegistries;

public class CreateGolemRecipeGen {
    private static final Set<String> SPECIAL = Set.of("andesite_alloy", "brass", "railway");

    public static void genAllUpgradeRecipes(RegistrateRecipeProvider pvd) {
        Map<ResourceLocation, Ingredient> ing = CompatManager.gatherConfig();
        for (GolemPart<?, ?> part : GolemPart.LIST) {
            for (Map.Entry<ResourceLocation, Ingredient> ent : ing.entrySet()) {
                if (SPECIAL.contains(ent.getKey().m_135815_()) || ent.getKey().m_135827_().equals("tconstruct")) continue;
                CreateGolemRecipeGen.genAssembly(pvd, part, ent.getKey(), ent.getValue(), new ItemLike[0]);
            }
        }
        CreateGolemRecipeGen.genSpecialRecipes(pvd);
    }

    public static void genSpecialRecipes(RegistrateRecipeProvider pvd) {
        for (GolemPart<?, ?> part : GolemPart.LIST) {
            CreateGolemRecipeGen.genAssembly(pvd, part, new ResourceLocation("create", "andesite_alloy"), (ItemLike)AllItems.ANDESITE_ALLOY, new ItemLike[]{AllBlocks.COGWHEEL});
            CreateGolemRecipeGen.genAssembly(pvd, part, new ResourceLocation("create", "brass"), Ingredient.m_204132_((TagKey)AllTags.forgeItemTag((String)"ingots/brass")), new ItemLike[]{AllItems.PRECISION_MECHANISM});
            CreateGolemRecipeGen.genAssembly(pvd, part, new ResourceLocation("create", "railway"), Ingredient.m_204132_((TagKey)AllTags.forgeItemTag((String)"plates/brass")), new ItemLike[]{AllItems.PRECISION_MECHANISM, AllItems.ELECTRON_TUBE, AllItems.STURDY_SHEET});
        }
    }

    private static void genAssembly(RegistrateRecipeProvider pvd, GolemPart<?, ?> part, ResourceLocation id, ItemLike ingredient, ItemLike ... parts) {
        CreateGolemRecipeGen.genAssembly(pvd, part, id, Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient}), parts);
    }

    private static void genAssembly(RegistrateRecipeProvider pvd, GolemPart<?, ?> part, ResourceLocation id, Ingredient ingredient, ItemLike ... parts) {
        ResourceLocation part_rl = ForgeRegistries.ITEMS.getKey(part);
        assert (part_rl != null);
        String item_name = part_rl.m_135815_();
        ConditionalSARecipeBuilder recipe = new ConditionalSARecipeBuilder(new ResourceLocation("modulargolems", id.m_135815_() + "_assemble_" + item_name));
        Item incomplete = (Item)ForgeRegistries.ITEMS.getValue(part_rl.m_246208_("incomplete_"));
        recipe.require((ItemLike)part).transitionTo((ItemLike)incomplete);
        recipe.addStep(DeployerApplicationRecipe::new, e -> e.require(ingredient));
        if (parts.length == 0) {
            for (int i = 0; i < 3; ++i) {
                recipe.addStep(PressingRecipe::new, e -> e);
            }
        } else {
            recipe.addStep(PressingRecipe::new, e -> e);
            for (ItemLike p : parts) {
                recipe.addStep(DeployerApplicationRecipe::new, e -> e.require(p));
            }
            recipe.addStep(DeployerApplicationRecipe::new, e -> e.require((ItemLike)AllItems.WRENCH).toolNotConsumed());
        }
        recipe.loops(part.count);
        String modid = id.m_135827_();
        recipe.withCondition((ICondition)new ModLoadedCondition("create"));
        if (!modid.equals("modulargolems") && !modid.equals("create")) {
            recipe.withCondition((ICondition)new ModLoadedCondition(modid));
        }
        recipe.addOutput(GolemPart.setMaterial(part.m_7968_(), id), 1.0f);
        recipe.build((Consumer)pvd);
    }
}

