/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.humanoid;

import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.mob_weapon_api.api.ai.ItemWrapper;
import dev.xkmc.mob_weapon_api.util.ShootUtils;
import dev.xkmc.modulargolems.content.entity.common.SweepGolemEntity;
import dev.xkmc.modulargolems.content.entity.dog.DogGolemEntity;
import dev.xkmc.modulargolems.content.entity.humanoid.HumanoidGolemPartType;
import dev.xkmc.modulargolems.content.entity.humanoid.weapon.GolemWeaponRegistry;
import dev.xkmc.modulargolems.content.item.golem.GolemHolder;
import dev.xkmc.modulargolems.events.event.GolemDamageShieldEvent;
import dev.xkmc.modulargolems.events.event.GolemDisableShieldEvent;
import dev.xkmc.modulargolems.events.event.GolemEquipEvent;
import dev.xkmc.modulargolems.events.event.GolemSweepEvent;
import dev.xkmc.modulargolems.init.advancement.GolemTriggers;
import dev.xkmc.modulargolems.init.data.MGConfig;
import dev.xkmc.modulargolems.init.data.MGTagGen;
import java.util.Arrays;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.eventbus.api.Event;

@SerialClass
public class HumanoidGolemEntity
extends SweepGolemEntity<HumanoidGolemEntity, HumanoidGolemPartType>
implements CrossbowAttackMob {
    private static final EntityDataAccessor<Boolean> IS_CHARGING_CROSSBOW = SynchedEntityData.m_135353_(HumanoidGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @SerialClass.SerialField(toClient=true)
    public int shieldCooldown = 0;
    @SerialClass.SerialField
    private ItemStack backupHand = ItemStack.f_41583_;
    @SerialClass.SerialField
    private ItemStack arrowSlot = ItemStack.f_41583_;
    protected boolean rendering;
    protected boolean render_trigger = false;

    public HumanoidGolemEntity(EntityType<HumanoidGolemEntity> type, Level level) {
        super(GolemWeaponRegistry.HUMANOID, type, level);
        if (!this.m_9236_().f_46443_) {
            this.groundNavigation.m_26477_(true);
        }
    }

    public ItemStack m_6298_(ItemStack pShootable) {
        ItemStack ans;
        if (pShootable.m_41720_() instanceof ProjectileWeaponItem) {
            Predicate predicate = ((ProjectileWeaponItem)pShootable.m_41720_()).m_6442_();
            ItemStack stack = ProjectileWeaponItem.m_43010_((LivingEntity)this, (Predicate)predicate);
            if (stack.m_41619_() && !this.arrowSlot.m_41619_() && predicate.test(this.arrowSlot)) {
                stack = this.arrowSlot;
            }
            ans = ForgeHooks.getProjectile((LivingEntity)this, (ItemStack)pShootable, (ItemStack)stack);
        } else {
            ans = ForgeHooks.getProjectile((LivingEntity)this, (ItemStack)pShootable, (ItemStack)ItemStack.f_41583_);
        }
        if (this.isHostile()) {
            ans = ans.m_41777_();
        }
        return ans;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_CHARGING_CROSSBOW, (Object)false);
    }

    @Override
    public InteractionHand getWeaponHand() {
        ItemStack stack = this.m_21205_();
        InteractionHand hand = InteractionHand.MAIN_HAND;
        if (stack.canPerformAction(ToolActions.SHIELD_BLOCK)) {
            hand = InteractionHand.OFF_HAND;
        }
        return hand;
    }

    public boolean m_21254_() {
        boolean ans;
        boolean bl = ans = this.shieldCooldown == 0 && this.m_5912_() && this.shieldSlot() != null;
        if (ans && this.rendering) {
            this.render_trigger = true;
        }
        return ans;
    }

    public ItemStack m_21211_() {
        ItemStack ans = super.m_21211_();
        if (this.rendering && this.render_trigger) {
            this.render_trigger = false;
            InteractionHand hand = this.shieldSlot();
            if (hand != null) {
                return this.m_21120_(hand);
            }
        }
        return ans;
    }

    public void m_21166_(EquipmentSlot pSlot) {
        super.m_21166_(pSlot);
        Player player = this.getOwner();
        if (player != null) {
            GolemTriggers.BREAK.trigger((ServerPlayer)player);
        }
    }

    @Override
    public boolean m_7327_(Entity target) {
        boolean can_sweep = this.m_21205_().canPerformAction(ToolActions.SWORD_SWEEP);
        if (!can_sweep) {
            if (super.m_7327_(target)) {
                ItemStack stack = this.m_6844_(EquipmentSlot.MAINHAND);
                stack.m_41622_(1, (LivingEntity)this, self -> self.m_21166_(EquipmentSlot.MAINHAND));
                return true;
            }
        } else if (this.performRangedDamage(target, 0.0f, 0.0)) {
            ItemStack stack = this.m_6844_(EquipmentSlot.MAINHAND);
            stack.m_41622_(1, (LivingEntity)this, self -> self.m_21166_(EquipmentSlot.MAINHAND));
            return true;
        }
        return false;
    }

    @Override
    protected AABB getAttackBoundingBox(Entity target, double range) {
        GolemSweepEvent event = new GolemSweepEvent(this, this.m_21205_(), target, range);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getBox();
    }

    @Override
    protected boolean performDamageTarget(Entity target, float damage, double kb) {
        return super.m_7327_(target);
    }

    @Override
    protected InteractionResult mobInteractImpl(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (((Boolean)MGConfig.COMMON.strictInteract.get()).booleanValue() && !itemstack.m_41619_()) {
            return InteractionResult.PASS;
        }
        if (player.m_6144_()) {
            if (this.canModify(player)) {
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    this.dropSlot(slot, false);
                }
            }
            if (itemstack.m_41619_()) {
                super.mobInteractImpl(player, hand);
            }
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_41619_()) {
            return super.mobInteractImpl(player, hand);
        }
        if (itemstack.m_41720_() instanceof GolemHolder || !itemstack.m_41720_().m_142095_() || !this.canModify(player)) {
            return InteractionResult.FAIL;
        }
        GolemEquipEvent event = new GolemEquipEvent(this, itemstack);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.canEquip()) {
            if (this.m_9236_().m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            if (this.m_21033_(event.getSlot())) {
                this.dropSlot(event.getSlot(), false);
            }
            if (this.m_21033_(event.getSlot())) {
                return InteractionResult.FAIL;
            }
            this.m_8061_(event.getSlot(), itemstack.m_41620_(event.getAmount()));
            int count = (int)Arrays.stream(EquipmentSlot.values()).filter(e -> !this.m_6844_((EquipmentSlot)e).m_41619_()).count();
            GolemTriggers.EQUIP.trigger((ServerPlayer)player, count);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    public double m_6049_() {
        return (double)(-this.m_20206_()) * 0.18;
    }

    @Override
    public void checkRide(LivingEntity target) {
        if (target instanceof DogGolemEntity || target instanceof AbstractHorse) {
            this.m_20329_((Entity)target);
        }
    }

    @Override
    public boolean canSweep() {
        return this.m_21205_().canPerformAction(ToolActions.SWORD_SWEEP);
    }

    protected void m_6472_(DamageSource source, float damage) {
        if (damage <= 0.0f) {
            return;
        }
        if ((damage /= 4.0f) < 1.0f) {
            damage = 1.0f;
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
            ItemStack itemstack = this.m_6844_(slot);
            if (source.m_269533_(DamageTypeTags.f_268745_) && itemstack.m_41720_().m_41475_() || !(itemstack.m_41720_() instanceof ArmorItem)) continue;
            itemstack.m_41622_((int)damage, (LivingEntity)this, entity -> entity.m_21166_(slot));
        }
    }

    @Nullable
    public InteractionHand shieldSlot() {
        return this.m_6844_(EquipmentSlot.MAINHAND).canPerformAction(ToolActions.SHIELD_BLOCK) ? InteractionHand.MAIN_HAND : (this.m_6844_(EquipmentSlot.OFFHAND).canPerformAction(ToolActions.SHIELD_BLOCK) ? InteractionHand.OFF_HAND : null);
    }

    protected void m_7909_(float damage) {
        InteractionHand hand = this.shieldSlot();
        if (hand == null) {
            return;
        }
        ItemStack stack = this.m_21120_(hand);
        int i = damage < 3.0f ? 0 : 1 + Mth.m_14143_((float)damage);
        GolemDamageShieldEvent event = new GolemDamageShieldEvent(this, stack, hand, damage, i);
        MinecraftForge.EVENT_BUS.post((Event)event);
        i = event.getCost();
        if (i > 0) {
            stack.m_41622_(i, (LivingEntity)this, self -> self.m_21190_(hand));
        }
        if (stack.m_41619_()) {
            this.m_21008_(hand, ItemStack.f_41583_);
            this.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + this.m_9236_().f_46441_.m_188501_() * 0.4f);
        } else {
            this.m_5496_(SoundEvents.f_12346_, 0.8f, 0.8f + this.m_9236_().f_46441_.m_188501_() * 0.4f);
        }
    }

    protected void m_6728_(LivingEntity source) {
        super.m_6728_(source);
        InteractionHand hand = this.shieldSlot();
        if (hand == null) {
            return;
        }
        ItemStack stack = this.m_21120_(hand);
        boolean canDisable = source.m_213824_() || source.m_21205_().canDisableShield(stack, (LivingEntity)this, source);
        int cd = 100;
        if (((Boolean)MGConfig.COMMON.bossBreakShield.get()).booleanValue() && source.m_6095_().m_204039_(MGTagGen.SHIELD_BREAKER)) {
            canDisable = true;
            cd *= 2;
        }
        GolemDisableShieldEvent event = new GolemDisableShieldEvent(this, stack, hand, source, canDisable);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.shouldDisable()) {
            this.shieldCooldown = cd;
            this.m_9236_().m_7605_((Entity)this, (byte)30);
        }
    }

    @Override
    public void m_7822_(byte event) {
        if (event == 30) {
            this.shieldCooldown = 100;
        }
        super.m_7822_(event);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.shieldCooldown = Mth.m_14045_((int)(this.shieldCooldown - 1), (int)0, (int)100);
    }

    @Override
    protected ItemWrapper getAltWeaponHand() {
        return !this.backupHand.m_41619_() ? this.getBackupHand() : this.getWrapperOfHand(EquipmentSlot.OFFHAND);
    }

    public ItemWrapper getBackupHand() {
        return ItemWrapper.simple(() -> this.backupHand, e -> {
            this.backupHand = e;
        });
    }

    public ItemWrapper getArrowSlot() {
        return ItemWrapper.simple(() -> this.arrowSlot, e -> {
            this.arrowSlot = e;
        });
    }

    public boolean isChargingCrossbow() {
        return (Boolean)this.f_19804_.m_135370_(IS_CHARGING_CROSSBOW);
    }

    public void m_6136_(boolean pIsCharging) {
        this.f_19804_.m_135381_(IS_CHARGING_CROSSBOW, (Object)pIsCharging);
    }

    public void m_5847_() {
        this.f_20891_ = 0;
    }

    public void m_5811_(LivingEntity target, ItemStack stack, Projectile e, float a) {
        this.m_32322_((LivingEntity)this, target, e, a, 3.0f);
    }

    public void m_32322_(LivingEntity user, LivingEntity target, Projectile e, float a, float v) {
        ShootUtils.getShootVector((LivingEntity)target, (Vec3)e.m_20182_(), (float)v, (float)0.05f, (float)0.0f).shoot(e, a);
        user.m_5496_(SoundEvents.f_11847_, 1.0f, 1.0f / (user.m_217043_().m_188501_() * 0.4f + 0.8f));
    }

    public void m_32336_(LivingEntity pUser, float pVelocity) {
        InteractionHand interactionhand = ProjectileUtil.getWeaponHoldingHand((LivingEntity)pUser, item -> item instanceof CrossbowItem);
        ItemStack itemstack = pUser.m_21120_(interactionhand);
        if (pUser.m_21093_(is -> is.m_41720_() instanceof CrossbowItem)) {
            CrossbowItem.m_40887_((Level)pUser.m_9236_(), (LivingEntity)pUser, (InteractionHand)interactionhand, (ItemStack)itemstack, (float)pVelocity, (float)0.0f);
        }
        this.m_5847_();
    }

    @Override
    protected void m_7472_(DamageSource source, int i, boolean b) {
        super.m_7472_(source, i, b);
        if (!this.arrowSlot.m_41619_()) {
            this.m_19983_(this.arrowSlot);
        }
        if (!this.backupHand.m_41619_()) {
            this.m_19983_(this.backupHand);
        }
    }
}

