/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.humanoid;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.xkmc.modulargolems.compat.curio.CuriosClientRegistry;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemRenderer;
import dev.xkmc.modulargolems.content.entity.common.GolemBannerLayer;
import dev.xkmc.modulargolems.content.entity.humanoid.HumanoidGolemEntity;
import dev.xkmc.modulargolems.content.entity.humanoid.HumanoidGolemModel;
import dev.xkmc.modulargolems.content.entity.humanoid.HumanoidGolemPartType;
import dev.xkmc.modulargolems.content.entity.humanoid.ItemInGolemHandLayer;
import dev.xkmc.modulargolems.content.entity.humanoid.LayerWrapper;
import dev.xkmc.modulargolems.content.entity.humanoid.skin.ClientSkinDispatch;
import dev.xkmc.modulargolems.content.entity.humanoid.skin.SpecialRenderSkin;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.Nullable;

public class HumanoidGolemRenderer
extends AbstractGolemRenderer<HumanoidGolemEntity, HumanoidGolemPartType, HumanoidGolemModel> {
    public static final ThreadLocal<HumanoidGolemModel> MODEL_DELEGATE = new ThreadLocal();

    protected static void transform(PoseStack stack, ItemDisplayContext transform, @Nullable HumanoidGolemPartType part) {
        float size;
        switch (transform) {
            case GUI: 
            case FIRST_PERSON_LEFT_HAND: 
            case FIRST_PERSON_RIGHT_HAND: {
                break;
            }
            case THIRD_PERSON_LEFT_HAND: 
            case THIRD_PERSON_RIGHT_HAND: {
                stack.m_85837_(0.25, 0.4, 0.5);
                size = 0.625f;
                stack.m_85841_(size, size, size);
                break;
            }
            case GROUND: {
                stack.m_85837_(0.25, 0.0, 0.5);
                size = 0.625f;
                stack.m_85841_(size, size, size);
                break;
            }
            case NONE: 
            case HEAD: 
            case FIXED: {
                stack.m_85837_(0.5, 0.5, 0.5);
                float size2 = 0.5f;
                stack.m_85841_(size2, -size2, size2);
                stack.m_85837_(0.0, -0.5, 0.0);
                return;
            }
            default: {
                stack.m_85837_(0.0, 0.0, 0.5);
            }
        }
        stack.m_252781_(Axis.f_252403_.m_252977_(135.0f));
        stack.m_252781_(Axis.f_252436_.m_252977_(-155.0f));
        if (part == null) {
            size = 0.45f;
            stack.m_85841_(size, size, size);
            stack.m_252880_(0.0f, -2.0f, 0.0f);
        } else if (part == HumanoidGolemPartType.BODY) {
            size = 0.65f;
            stack.m_85841_(size, size, size);
            stack.m_85837_(0.0, -1.2, 0.0);
        } else if (part == HumanoidGolemPartType.LEGS) {
            size = 0.8f;
            stack.m_85841_(size, size, size);
            stack.m_252880_(0.0f, -2.0f, 0.0f);
        } else if (part == HumanoidGolemPartType.ARMS) {
            size = 0.6f;
            stack.m_85841_(size, size, size);
            stack.m_85837_(0.0, -1.5, 0.0);
        }
    }

    public HumanoidGolemRenderer(EntityRendererProvider.Context ctx) {
        this(ctx, false);
    }

    public HumanoidGolemRenderer(EntityRendererProvider.Context ctx, boolean slim) {
        super(ctx, new HumanoidGolemModel(ctx.m_174023_(slim ? ModelLayers.f_171166_ : ModelLayers.f_171162_), slim), 0.5f, HumanoidGolemPartType::values);
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(ctx.m_174023_(slim ? ModelLayers.f_171167_ : ModelLayers.f_171164_)), new HumanoidModel(ctx.m_174023_(slim ? ModelLayers.f_171168_ : ModelLayers.f_171165_)), ctx.m_266367_()));
        this.m_115326_((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, ctx.m_174027_(), 1.0f, 1.0f, 1.0f, ctx.m_234598_()));
        this.m_115326_((RenderLayer)new ElytraLayer((RenderLayerParent)this, ctx.m_174027_()));
        this.m_115326_(new LayerWrapper(this, new ItemInGolemHandLayer(this, ctx.m_234598_())));
        this.m_115326_(new GolemBannerLayer(this, ctx.m_234598_()));
        if (ModList.get().isLoaded("curios")) {
            CuriosClientRegistry.createLayer(this);
        }
    }

    @Override
    public void render(HumanoidGolemEntity entity, float f1, float f2, PoseStack stack, MultiBufferSource source, int i) {
        Entity camera = Minecraft.m_91087_().m_91288_();
        if (Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON && camera != null && camera.m_20202_() != null && entity.m_20202_() == camera.m_20202_()) {
            return;
        }
        SpecialRenderSkin profile = ClientSkinDispatch.get(entity);
        if (profile != null) {
            profile.render(entity, f1, f2, stack, source, i);
            return;
        }
        this.renderImpl(entity, f1, f2, stack, source, i);
    }

    public void renderImpl(HumanoidGolemEntity entity, float f1, float f2, PoseStack stack, MultiBufferSource source, int i) {
        super.render(entity, f1, f2, stack, source, i);
    }

    public HumanoidGolemModel getModel() {
        HumanoidGolemModel override = MODEL_DELEGATE.get();
        if (override != null) {
            return override;
        }
        return (HumanoidGolemModel)super.m_7200_();
    }
}

