/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.soldering;

import commoble.morered.MoreRed;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public class SolderingRecipe
extends ShapelessRecipe {
    public SolderingRecipe(ShapelessRecipe baseRecipe) {
        super(baseRecipe.m_6423_(), baseRecipe.m_6076_(), baseRecipe.m_245232_(), baseRecipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_), baseRecipe.m_7527_());
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)MoreRed.get().solderingRecipeType.get();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)MoreRed.get().solderingSerializer.get();
    }

    public static boolean doesPlayerHaveIngredients(Inventory playerInventory, @Nonnull Recipe<CraftingContainer> recipe) {
        NonNullList ingredients = recipe.m_7527_();
        for (Ingredient ingredient : ingredients) {
            int remainingItems = ingredient.m_43908_()[0].m_41613_();
            int playerSlots = playerInventory.m_6643_();
            for (int playerSlot = 0; playerSlot < playerSlots && remainingItems > 0; ++playerSlot) {
                ItemStack stackInSlot = playerInventory.m_8020_(playerSlot);
                if (!ingredient.test(stackInSlot)) continue;
                remainingItems -= stackInSlot.m_41613_();
            }
            if (remainingItems <= 0) continue;
            return false;
        }
        return true;
    }

    public static List<Recipe<CraftingContainer>> getAllSolderingRecipes(RecipeManager manager, RegistryAccess registries) {
        Map map = manager.f_44007_.getOrDefault(MoreRed.get().solderingRecipeType.get(), Collections.emptyMap());
        return map.entrySet().stream().map(Map.Entry::getValue).sorted(Comparator.comparing(recipe -> recipe.m_8043_(registries).m_41778_())).collect(Collectors.toList());
    }
}

