/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.wire_post;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import commoble.morered.client.ClientProxy;
import commoble.morered.wire_post.PostsInChunk;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.network.NetworkEvent;

public class SyncPostsInChunkPacket {
    public static final Codec<ChunkPos> CHUNK_POS_CODEC = Codec.LONG.xmap(ChunkPos::new, ChunkPos::m_45588_);
    public static final Codec<SyncPostsInChunkPacket> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CHUNK_POS_CODEC.fieldOf("chunk").forGetter(SyncPostsInChunkPacket::getChunkPos), (App)PostsInChunk.DATA_CODEC.fieldOf("positions").forGetter(SyncPostsInChunkPacket::getPostsInChunk)).apply((Applicative)instance, SyncPostsInChunkPacket::new));
    public static final SyncPostsInChunkPacket BAD_PACKET = new SyncPostsInChunkPacket(new ChunkPos(ChunkPos.f_45577_), (Set<BlockPos>)ImmutableSet.of());
    private final ChunkPos chunkPos;
    private final Set<BlockPos> inChunk;

    public ChunkPos getChunkPos() {
        return this.chunkPos;
    }

    public Set<BlockPos> getPostsInChunk() {
        return this.inChunk;
    }

    public SyncPostsInChunkPacket(ChunkPos chunkPos, Set<BlockPos> inChunk) {
        this.chunkPos = chunkPos;
        this.inChunk = inChunk;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130079_(CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this).result().orElse(new CompoundTag()));
    }

    public static SyncPostsInChunkPacket read(FriendlyByteBuf buffer) {
        return CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)buffer.m_130260_()).result().map(Pair::getFirst).orElse(BAD_PACKET);
    }

    public void handle(Supplier<NetworkEvent.Context> contextGetter) {
        NetworkEvent.Context context = contextGetter.get();
        context.enqueueWork(() -> ClientProxy.updatePostsInChunk(this.chunkPos, this.inChunk));
        context.setPacketHandled(true);
    }
}

