/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.blockentity.IPaintable;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.image.PaletteImage;
import com.mrcrayfish.furniture.refurbished.inventory.DoorMatMenu;
import com.mrcrayfish.furniture.refurbished.util.BlockEntityHelper;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.BitSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class DoorMatBlockEntity
extends BlockEntity
implements MenuProvider,
IPaintable {
    public static final int IMAGE_WIDTH = 14;
    public static final int IMAGE_HEIGHT = 10;
    @Nullable
    private Player paintingPlayer;
    @Nullable
    private PaletteImage image;
    private boolean finalised;

    public DoorMatBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.DOOR_MAT.get(), pos, state);
    }

    @Override
    public void setImage(PaletteImage image) {
        if (image.getWidth() == 14 && image.getHeight() == 10) {
            this.image = image;
            this.m_6596_();
            BlockEntityHelper.sendCustomUpdate(this, this.m_5995_());
        }
    }

    @Override
    public PaletteImage getImage() {
        return this.image;
    }

    @Override
    @Nullable
    public Player getPainter() {
        return this.paintingPlayer;
    }

    @Override
    public void setPainter(@Nullable Player player) {
        this.paintingPlayer = player;
    }

    @Override
    public boolean isEditable() {
        return !this.finalised;
    }

    @Override
    public void setEditable(boolean state) {
        if (!this.finalised && !state) {
            this.finalised = true;
            this.m_6596_();
        }
    }

    @Override
    public boolean isValid(Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player) && player.equals((Object)this.getPainter());
    }

    public Component m_5446_() {
        return Utils.translation("container", "door_mat", new Object[0]);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new DoorMatMenu(windowId, playerInventory, this);
    }

    public void m_142466_(CompoundTag tag) {
        long[] data;
        BitSet bits;
        super.m_142466_(tag);
        if (tag.m_128425_("Image", 12) && (bits = BitSet.valueOf(data = tag.m_128467_("Image"))).size() >= 140) {
            this.image = new PaletteImage(14, 10, () -> bits);
        }
        if (tag.m_128425_("Finalised", 1)) {
            this.finalised = tag.m_128471_("Finalised");
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.image != null) {
            long[] data = this.image.getData().toLongArray();
            tag.m_128388_("Image", data);
        }
        tag.m_128379_("Finalised", this.finalised);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }
}

