/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.bytecodecs;

import com.teamresourceful.bytecodecs.base.ByteCodec;
import com.teamresourceful.bytecodecs.base.ObjectEntryByteCodec;
import com.teamresourceful.bytecodecs.base.object.ObjectByteCodec;
import com.teamresourceful.resourcefullib.common.bytecodecs.CompoundTagByteCodec;
import com.teamresourceful.resourcefullib.common.bytecodecs.IdMapByteCodec;
import com.teamresourceful.resourcefullib.common.bytecodecs.ItemStackByteCodec;
import com.teamresourceful.resourcefullib.common.exceptions.UtilityClassException;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;

public final class ExtraByteCodecs {
    public static final ByteCodec<ResourceLocation> RESOURCE_LOCATION = ByteCodec.STRING.map(ResourceLocation::new, ResourceLocation::toString);
    public static final ByteCodec<ResourceKey<Level>> DIMENSION = ExtraByteCodecs.resourceKey(Registries.f_256858_);
    public static final ByteCodec<BlockPos> BLOCK_POS = ByteCodec.LONG.map(BlockPos::m_122022_, BlockPos::m_121878_);
    public static final ByteCodec<ChunkPos> CHUNK_POS = ByteCodec.LONG.map(ChunkPos::new, ChunkPos::m_45588_);
    public static final ByteCodec<SectionPos> SECTION_POS = ByteCodec.LONG.map(SectionPos::m_123184_, SectionPos::m_123252_);
    public static final ByteCodec<GlobalPos> GLOBAL_POS = ObjectByteCodec.create((ObjectEntryByteCodec)DIMENSION.fieldOf(GlobalPos::m_122640_), (ObjectEntryByteCodec)BLOCK_POS.fieldOf(GlobalPos::m_122646_), GlobalPos::m_122643_);
    public static final ByteCodec<Vector3f> VECTOR_3F = ObjectByteCodec.create((ObjectEntryByteCodec)ByteCodec.FLOAT.fieldOf(Vector3f::x), (ObjectEntryByteCodec)ByteCodec.FLOAT.fieldOf(Vector3f::y), (ObjectEntryByteCodec)ByteCodec.FLOAT.fieldOf(Vector3f::z), Vector3f::new);
    public static final ByteCodec<CompoundTag> NULLABLE_COMPOUND_TAG = CompoundTagByteCodec.INSTANCE.map(value -> value.orElse(null), Optional::ofNullable);
    public static final ByteCodec<CompoundTag> NONNULL_COMPOUND_TAG = CompoundTagByteCodec.INSTANCE.map(Optional::orElseThrow, Optional::of);
    public static final ByteCodec<Optional<CompoundTag>> COMPOUND_TAG = CompoundTagByteCodec.INSTANCE;
    public static final ByteCodec<Component> COMPONENT = ByteCodec.STRING_COMPONENT.map(Component.Serializer::m_130701_, Component.Serializer::m_130703_);
    public static final ByteCodec<Item> ITEM = ExtraByteCodecs.registry(BuiltInRegistries.f_257033_);
    public static final ByteCodec<ItemStack> ITEM_STACK = ItemStackByteCodec.CODEC;

    private ExtraByteCodecs() throws UtilityClassException {
        throw new UtilityClassException();
    }

    public static <T, R extends Registry<T>> ByteCodec<ResourceKey<T>> resourceKey(ResourceKey<R> registry) {
        return RESOURCE_LOCATION.map(id -> ResourceKey.m_135785_((ResourceKey)registry, (ResourceLocation)id), ResourceKey::m_135782_);
    }

    public static <T> ByteCodec<T> registry(IdMap<T> map) {
        return new IdMapByteCodec<T>(map);
    }
}

