/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import xyz.przemyk.simpleplanes.entities.CargoPlaneEntity;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;

public class NewCargoUpgradePacket {
    private final ResourceLocation upgradeID;
    private final int planeEntityID;
    private Upgrade upgrade;
    private FriendlyByteBuf packetBuffer;

    public NewCargoUpgradePacket(ResourceLocation upgradeID, int planeEntityID, Upgrade upgrade) {
        this.upgradeID = upgradeID;
        this.planeEntityID = planeEntityID;
        this.upgrade = upgrade;
    }

    public NewCargoUpgradePacket(FriendlyByteBuf buffer) {
        this.planeEntityID = buffer.m_130242_();
        this.upgradeID = buffer.m_130281_();
        this.packetBuffer = buffer;
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.planeEntityID);
        buffer.m_130085_(this.upgradeID);
        this.upgrade.writePacket(buffer);
    }

    public void handle(Supplier<NetworkEvent.Context> ctxSup) {
        NetworkEvent.Context ctx = ctxSup.get();
        ctx.enqueueWork(() -> {
            ClientLevel clientWorld = Minecraft.m_91087_().f_91073_;
            ((CargoPlaneEntity)clientWorld.m_6815_(this.planeEntityID)).readNewCargoUpgradePacket(this.upgradeID, this.packetBuffer);
        });
        ctx.setPacketHandled(true);
    }
}

