/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.api.central;

import com.codinglitch.lexiconfig.classes.LexiconPageData;
import com.codinglitch.simpleradio.api.central.Frequency;
import net.minecraft.resources.ResourceLocation;

public class FrequencingType {
    public ResourceLocation location;
    public short id;
    public int receptionPower;
    public int receptionFloor;
    public int antennaAptitude;
    public int transmissionPowerFM;
    public int diminishThresholdFM;
    public int transmissionPowerAM;
    public int diminishThresholdAM;
    public DiminishmentMethod diminishmentMethod;
    public double transmissionDiminishment;
    public LexiconPageData page;

    public void reload() {
        if (this.page == null) {
            return;
        }
        this.receptionPower = this.page.getEntry("receptionPower").orElse(-1);
        this.receptionFloor = this.page.getEntry("receptionFloor").orElse(-1);
        this.antennaAptitude = this.page.getEntry("antennaAptitude").orElse(-1);
        this.transmissionPowerFM = this.page.getEntry("transmissionPowerFM").orElse(-1);
        this.diminishThresholdFM = this.page.getEntry("diminishThresholdFM").orElse(-1);
        this.transmissionPowerAM = this.page.getEntry("transmissionPowerAM").orElse(-1);
        this.diminishThresholdAM = this.page.getEntry("diminishThresholdAM").orElse(-1);
        this.diminishmentMethod = DiminishmentMethod.valueOf(this.page.getEntry("diminishmentMethod").orElse("ADDITIVE"));
        this.transmissionDiminishment = this.page.getEntry("transmissionDiminishment").orElse(-1.0);
    }

    public int getTransmissionPower(Frequency.Modulation modulation) {
        return modulation == Frequency.Modulation.AMPLITUDE ? this.transmissionPowerAM : this.transmissionPowerFM;
    }

    public int getDiminishThreshold(Frequency.Modulation modulation) {
        return modulation == Frequency.Modulation.AMPLITUDE ? this.diminishThresholdAM : this.diminishThresholdFM;
    }

    public static enum DiminishmentMethod {
        ADDITIVE,
        MULTIPLICATIVE;

    }
}

