/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.compat.create;

import com.codinglitch.simpleradio.api.central.Frequency;
import com.codinglitch.simpleradio.api.central.Routing;
import com.codinglitch.simpleradio.api.central.WorldlyPosition;
import com.codinglitch.simpleradio.radio.RadioRouter;
import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import java.util.UUID;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CentralMovementBehaviour
implements MovementBehaviour {
    public void updateRouter(MovementContext context, RadioRouter router, WorldlyPosition newLocation, AbstractContraptionEntity contraption) {
        if (router == null) {
            return;
        }
        if (router.owner != contraption) {
            router.owner = contraption;
        }
        if (context.world.f_46443_) {
            Vector3f translatedNorth = ((Vec3)context.rotation.apply(new Vec3(0.0, 0.0, -1.0))).m_252839_();
            if (router.rotation == null) {
                router.rotation = new Quaternionf();
            }
            router.rotation.setAngleAxis(translatedNorth.angle((Vector3fc)new Vector3f(0.0f, 0.0f, -1.0f)) * -Math.signum(translatedNorth.x), 0.0f, 1.0f, 0.0f);
        }
        router.location.x = newLocation.x;
        router.location.y = newLocation.y;
        router.location.z = newLocation.z;
        router.updateLocation(newLocation);
    }

    public void update(MovementContext context) {
        AbstractContraptionEntity contraptionEntity = context.contraption.entity;
        if (contraptionEntity == null) {
            return;
        }
        Block block = context.state.m_60734_();
        if (!(block instanceof Routing)) {
            return;
        }
        Routing routing = (Routing)block;
        if (context.blockEntityData.m_128441_("uuid")) {
            WorldlyPosition newLocation;
            UUID id = context.blockEntityData.m_128342_("uuid");
            if (context.world.f_46443_) {
                double partialTick = AnimationTickHolder.getPartialTicks();
                Vec3 pos = context.position.m_82549_(context.motion.m_82490_(partialTick));
                newLocation = WorldlyPosition.of(pos.m_252839_(), context.world);
            } else {
                newLocation = WorldlyPosition.of(context.position.m_252839_(), context.world);
            }
            Frequency frequency = Frequency.fromTag(context.blockEntityData);
            if (frequency != null) {
                this.updateRouter(context, routing.getOrCreateReceiver(newLocation, frequency, id, context.state), newLocation, contraptionEntity);
                this.updateRouter(context, routing.getOrCreateTransmitter(newLocation, frequency, id, context.state), newLocation, contraptionEntity);
            }
            this.updateRouter(context, routing.getOrCreateSpeaker(newLocation, id, context.state), newLocation, contraptionEntity);
            this.updateRouter(context, routing.getOrCreateListener(newLocation, id, context.state), newLocation, contraptionEntity);
            this.updateRouter(context, routing.getOrCreateRouter(newLocation, id, context.state), newLocation, contraptionEntity);
        }
    }

    public void visitNewPosition(MovementContext context, BlockPos pos) {
        super.visitNewPosition(context, pos);
        if (context.world.m_5776_()) {
            return;
        }
        this.update(context);
    }

    public void tick(MovementContext context) {
        super.tick(context);
        if (context.world.m_5776_()) {
            return;
        }
        this.update(context);
    }

    public void startMoving(MovementContext context) {
        super.startMoving(context);
    }

    public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
        super.renderInContraption(context, renderWorld, matrices, buffer);
        AbstractContraptionEntity contraptionEntity = context.contraption.entity;
        if (contraptionEntity == null) {
            return;
        }
        this.update(context);
    }
}

