/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics.debug;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.sonicether.soundphysics.SoundPhysicsMod;
import com.sonicether.soundphysics.utils.RenderTypeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class RaycastRenderer {
    private static final List<Ray> rays = Collections.synchronizedList(new ArrayList());
    private static final Minecraft mc = Minecraft.m_91087_();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderRays(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, double x, double y, double z) {
        if (RaycastRenderer.mc.f_91073_ == null) {
            return;
        }
        if (!SoundPhysicsMod.CONFIG.renderSoundBounces.get().booleanValue() && !SoundPhysicsMod.CONFIG.renderOcclusion.get().booleanValue()) {
            List<Ray> list = rays;
            synchronized (list) {
                rays.clear();
            }
            return;
        }
        long gameTime = RaycastRenderer.mc.f_91073_.m_46467_();
        List<Ray> list = rays;
        synchronized (list) {
            rays.removeIf(ray -> gameTime - ray.tickCreated > ray.lifespan || gameTime - ray.tickCreated < 0L);
            for (Ray ray2 : rays) {
                RaycastRenderer.renderRay(ray2, poseStack, bufferSource, x, y, z);
            }
        }
    }

    public static void addSoundBounceRay(Vec3 start, Vec3 end, int color) {
        if (!SoundPhysicsMod.CONFIG.renderSoundBounces.get().booleanValue()) {
            return;
        }
        RaycastRenderer.addRay(start, end, color, false);
    }

    public static void addOcclusionRay(Vec3 start, Vec3 end, int color) {
        if (!SoundPhysicsMod.CONFIG.renderOcclusion.get().booleanValue()) {
            return;
        }
        RaycastRenderer.addRay(start, end, color, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRay(Vec3 start, Vec3 end, int color, boolean throughWalls) {
        if (RaycastRenderer.mc.f_91074_.m_20182_().m_82554_(start) > 32.0 && RaycastRenderer.mc.f_91074_.m_20182_().m_82554_(end) > 32.0) {
            return;
        }
        List<Ray> list = rays;
        synchronized (list) {
            rays.add(new Ray(start, end, color, throughWalls));
        }
    }

    public static void renderRay(Ray ray, PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, double x, double y, double z) {
        poseStack.m_85836_();
        int red = RaycastRenderer.getRed(ray.color);
        int green = RaycastRenderer.getGreen(ray.color);
        int blue = RaycastRenderer.getBlue(ray.color);
        VertexConsumer consumer = ray.throughWalls ? bufferSource.m_6299_((RenderType)RenderTypeUtils.DEBUG_LINE_STRIP_SEETHROUGH) : bufferSource.m_6299_(RenderTypeUtils.DEBUG_LINE_STRIP);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        consumer.m_252986_(matrix4f, (float)(ray.start.f_82479_ - x), (float)(ray.start.f_82480_ - y), (float)(ray.start.f_82481_ - z)).m_6122_(red, green, blue, 255).m_5752_();
        consumer.m_252986_(matrix4f, (float)(ray.end.f_82479_ - x), (float)(ray.end.f_82480_ - y), (float)(ray.end.f_82481_ - z)).m_6122_(red, green, blue, 255).m_5752_();
        poseStack.m_85849_();
    }

    private static int getRed(int argb) {
        return argb >> 16 & 0xFF;
    }

    private static int getGreen(int argb) {
        return argb >> 8 & 0xFF;
    }

    private static int getBlue(int argb) {
        return argb & 0xFF;
    }

    private static class Ray {
        private final Vec3 start;
        private final Vec3 end;
        private final int color;
        private final long tickCreated;
        private final long lifespan;
        private final boolean throughWalls;

        public Ray(Vec3 start, Vec3 end, int color, boolean throughWalls) {
            this.start = start;
            this.end = end;
            this.color = color;
            this.throughWalls = throughWalls;
            this.tickCreated = RaycastRenderer.mc.f_91073_.m_46467_();
            this.lifespan = 40L;
        }
    }
}

