/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics.world;

import com.sonicether.soundphysics.world.ClientLevelProxy;
import com.sonicether.soundphysics.world.ClonedLevelChunk;
import com.sonicether.soundphysics.world.ClonedLevelHeightAccessor;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class ClonedClientLevel
implements ClientLevelProxy {
    private final ClonedLevelHeightAccessor heightAccessor;
    private final HashMap<ChunkPos, ClonedLevelChunk> clonedLevelChunks;
    private final BlockPos clonedLevelOrigin;
    private final long clonedLevelTick;

    public ClonedClientLevel(ClientLevel level, BlockPos origin, long tick, int range) {
        ClientChunkCache cache = level.m_7726_();
        ClonedLevelHeightAccessor heightAccessor = new ClonedLevelHeightAccessor((Level)level);
        HashMap<ChunkPos, ClonedLevelChunk> cachedLevelChunks = new HashMap<ChunkPos, ClonedLevelChunk>();
        ChunkPos originChunkPos = new ChunkPos(origin.m_123341_() >> 4, origin.m_123343_() >> 4);
        for (int x = -range; x < range; ++x) {
            for (int z = -range; z < range; ++z) {
                ChunkPos chunkPos = new ChunkPos(originChunkPos.f_45578_ + x, originChunkPos.f_45579_ + z);
                LevelChunk chunk = cache.m_62227_(chunkPos.f_45578_, chunkPos.f_45579_, false);
                if (chunk == null) continue;
                ClonedLevelChunk clonedChunk = new ClonedLevelChunk((Level)level, chunkPos, chunk.m_7103_());
                cachedLevelChunks.put(chunkPos, clonedChunk);
            }
        }
        this.heightAccessor = heightAccessor;
        this.clonedLevelOrigin = origin;
        this.clonedLevelTick = tick;
        this.clonedLevelChunks = cachedLevelChunks;
    }

    public BlockPos getOrigin() {
        return this.clonedLevelOrigin;
    }

    public long getTick() {
        return this.clonedLevelTick;
    }

    public ClonedLevelChunk getChunk(int x, int z) {
        ChunkPos chunkPos = new ChunkPos(x, z);
        return this.clonedLevelChunks.get(chunkPos);
    }

    public BlockState m_8055_(@Nonnull BlockPos blockPos) {
        if (this.m_151570_(blockPos)) {
            return Blocks.f_50626_.m_49966_();
        }
        ChunkPos chunkPos = new ChunkPos(blockPos.m_123341_() >> 4, blockPos.m_123343_() >> 4);
        ClonedLevelChunk levelChunk = this.clonedLevelChunks.get(chunkPos);
        if (levelChunk == null) {
            return Blocks.f_50626_.m_49966_();
        }
        return levelChunk.m_8055_(blockPos);
    }

    public FluidState m_6425_(@Nonnull BlockPos blockPos) {
        if (this.m_151570_(blockPos)) {
            return Fluids.f_76191_.m_76145_();
        }
        ChunkPos chunkPos = new ChunkPos(blockPos.m_123341_() >> 4, blockPos.m_123343_() >> 4);
        ClonedLevelChunk levelChunk = this.clonedLevelChunks.get(chunkPos);
        if (levelChunk == null) {
            return Fluids.f_76191_.m_76145_();
        }
        return levelChunk.m_6425_(blockPos);
    }

    public int m_141928_() {
        return this.heightAccessor.m_141928_();
    }

    public int m_141937_() {
        return this.heightAccessor.m_141937_();
    }

    public BlockEntity m_7702_(@Nonnull BlockPos blockPos) {
        ChunkPos chunkPos = new ChunkPos(blockPos.m_123341_() >> 4, blockPos.m_123343_() >> 4);
        ClonedLevelChunk levelChunk = this.clonedLevelChunks.get(chunkPos);
        if (levelChunk == null) {
            return null;
        }
        return levelChunk.m_7702_(blockPos);
    }
}

