/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Screens;

import com.Harbinger.Spore.Recipes.WombRecipe;
import com.Harbinger.Spore.Screens.AssimilationMenu;
import com.Harbinger.Spore.Sentities.VariantKeeper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class AssimilationScreen
extends AbstractContainerScreen<AssimilationMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("spore", "textures/gui/assimilation_gui.png");
    private final List<WombRecipe> recipes;
    private List<WombRecipe.Pair> mobPairs;
    private int tickCounter = 0;
    private int currentItemIndex = 0;
    private Button leftButton;
    private Button rightButton;
    private int currentEntityIndex = 0;
    ClientLevel level;

    public AssimilationScreen(AssimilationMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.level = Minecraft.m_91087_().f_91073_;
        this.f_97726_ = 176;
        this.f_97727_ = 166;
        this.recipes = this.level == null ? new ArrayList<WombRecipe>() : this.level.m_7465_().m_44013_((RecipeType)WombRecipe.WombRecipeType.INSTANCE);
    }

    private void changeRecipe(int direction) {
        if (!this.recipes.isEmpty()) {
            this.currentItemIndex = (this.currentItemIndex + direction) % this.recipes.size();
            this.currentEntityIndex = 0;
            if (this.currentItemIndex < 0) {
                this.currentItemIndex += this.recipes.size();
            }
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97731_ = 10000;
        this.f_97729_ = 10000;
        int buttonY = this.f_97736_ - 20;
        int buttonX = this.f_97735_ + 88;
        this.leftButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"<"), button -> this.changeRecipe(-1)).m_252987_(buttonX - 10, buttonY, 20, 20).m_253136_());
        this.rightButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)">"), button -> this.changeRecipe(1)).m_252987_(buttonX + 10, buttonY, 20, 20).m_253136_());
    }

    protected void m_7286_(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.m_280163_(TEXTURE, this.f_97735_, this.f_97736_, 0.0f, 0.0f, this.f_97726_, this.f_97727_, this.f_97726_, this.f_97727_);
        RenderSystem.disableBlend();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        int x = this.f_97735_ + 34;
        int y = this.f_97736_ + 70;
        this.m_280072_(guiGraphics, mouseX, mouseY);
        WombRecipe recipe = this.recipes.get(this.currentItemIndex);
        if (recipe == null) {
            return;
        }
        this.mobPairs = recipe.getEntityPairs();
        if (this.level != null) {
            WombRecipe.Pair pairs = this.mobPairs.get(this.currentEntityIndex);
            int variant = pairs.type();
            ResourceLocation location = new ResourceLocation(pairs.entityId());
            Entity entity = ((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(location)).m_20615_((Level)this.level);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                if (living instanceof VariantKeeper) {
                    VariantKeeper keeper = (VariantKeeper)living;
                    keeper.setVariant(variant);
                    this.renderEntityInInventoryFollowsAngle(guiGraphics, x, y, 20, 0.0f, 0.0f, living);
                } else {
                    this.renderEntityInInventoryFollowsAngle(guiGraphics, x, y, 20, 0.0f, 0.0f, living);
                }
            }
        }
        this.renderIcon(guiGraphics, recipe.getIcon());
        this.renderName(guiGraphics, recipe.getAttribute());
    }

    private void renderIcon(GuiGraphics guiGraphics, ResourceLocation iconLocation) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)iconLocation);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        int iconX = this.f_97735_ + 100;
        int iconY = this.f_97736_ + 30;
        int iconWidth = 32;
        int iconHeight = 32;
        guiGraphics.m_280163_(iconLocation, iconX, iconY, 0.0f, 0.0f, iconWidth, iconHeight, iconWidth, iconHeight);
        RenderSystem.disableBlend();
    }

    private void renderName(GuiGraphics guiGraphics, String attributeName) {
        String[] strings = attributeName.split(":");
        MutableComponent name = Component.m_237115_((String)("attribute.name.spore." + strings[1]));
        int iconX = this.f_97735_ + 100;
        int iconY = this.f_97736_ + 25;
        int iconWidth = 32;
        int textX = iconX + iconWidth / 2 - this.f_96547_.m_92852_((FormattedText)name) / 2;
        int textY = iconY - 10;
        guiGraphics.m_280614_(this.f_96547_, (Component)name, textX, textY, 0xFFFFFF, true);
    }

    private void renderEntityInInventoryFollowsAngle(GuiGraphics guiGraphics, int x, int y, int scale, float angleXComponent, float angleYComponent, LivingEntity entity) {
        Quaternionf pose = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf cameraOrientation = new Quaternionf().rotateX(angleYComponent * 20.0f * ((float)Math.PI / 180));
        pose.mul((Quaternionfc)cameraOrientation);
        float f2 = entity.f_20883_;
        float f3 = entity.m_146908_();
        float f4 = entity.m_146909_();
        float f5 = entity.f_20886_;
        float f6 = entity.f_20885_;
        entity.f_20883_ = 180.0f + angleXComponent * 20.0f;
        entity.m_146922_(180.0f + angleXComponent * 40.0f);
        entity.m_146926_(-angleYComponent * 20.0f);
        entity.f_20885_ = entity.m_146908_();
        entity.f_20886_ = entity.m_146908_();
        InventoryScreen.m_280432_((GuiGraphics)guiGraphics, (int)x, (int)y, (int)scale, (Quaternionf)pose, (Quaternionf)cameraOrientation, (LivingEntity)entity);
        entity.f_20883_ = f2;
        entity.m_146922_(f3);
        entity.m_146926_(f4);
        entity.f_20886_ = f5;
        entity.f_20885_ = f6;
    }

    protected void m_181908_() {
        super.m_181908_();
        if (!this.recipes.isEmpty()) {
            ++this.tickCounter;
            if (this.tickCounter % 40 == 0) {
                this.currentEntityIndex = (this.currentEntityIndex + 1) % this.mobPairs.size();
            }
        }
    }
}

