/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.network.message.handshake;

import com.tacz.guns.GunMod;
import com.tacz.guns.entity.sync.core.SyncedDataKey;
import com.tacz.guns.entity.sync.core.SyncedEntityData;
import com.tacz.guns.network.IMessage;
import com.tacz.guns.network.LoginIndexHolder;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.handshake.Acknowledge;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class ServerMessageSyncedEntityDataMapping
extends LoginIndexHolder
implements IMessage<ServerMessageSyncedEntityDataMapping> {
    public static final Marker HANDSHAKE = MarkerManager.getMarker((String)"TACZ_HANDSHAKE");
    private Map<ResourceLocation, List<Pair<ResourceLocation, Integer>>> keyMap;

    public ServerMessageSyncedEntityDataMapping() {
    }

    private ServerMessageSyncedEntityDataMapping(Map<ResourceLocation, List<Pair<ResourceLocation, Integer>>> keyMap) {
        this.keyMap = keyMap;
    }

    @Override
    public void encode(ServerMessageSyncedEntityDataMapping message, FriendlyByteBuf buffer) {
        Set<SyncedDataKey<?, ?>> keys = SyncedEntityData.instance().getKeys();
        buffer.writeInt(keys.size());
        keys.forEach(key -> {
            int id = SyncedEntityData.instance().getInternalId((SyncedDataKey<?, ?>)key);
            buffer.m_130085_(key.classKey().id());
            buffer.m_130085_(key.id());
            buffer.m_130130_(id);
        });
    }

    @Override
    public ServerMessageSyncedEntityDataMapping decode(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<ResourceLocation, List<Pair<ResourceLocation, Integer>>> keyMap = new HashMap<ResourceLocation, List<Pair<ResourceLocation, Integer>>>();
        for (int i = 0; i < size; ++i) {
            ResourceLocation classId = buffer.m_130281_();
            ResourceLocation keyId = buffer.m_130281_();
            int id = buffer.m_130242_();
            keyMap.computeIfAbsent(classId, c -> new ArrayList()).add(Pair.of((Object)keyId, (Object)id));
        }
        return new ServerMessageSyncedEntityDataMapping(keyMap);
    }

    @Override
    public void handle(ServerMessageSyncedEntityDataMapping message, Supplier<NetworkEvent.Context> supplier) {
        GunMod.LOGGER.debug(HANDSHAKE, "Received synced key mappings from server");
        CountDownLatch block = new CountDownLatch(1);
        supplier.get().enqueueWork(() -> {
            if (!SyncedEntityData.instance().updateMappings(message)) {
                ((NetworkEvent.Context)supplier.get()).getNetworkManager().m_129507_((Component)Component.m_237113_((String)"Connection closed - [TacZ] Received unknown synced data keys."));
            }
            block.countDown();
        });
        try {
            block.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        supplier.get().setPacketHandled(true);
        NetworkHandler.HANDSHAKE_CHANNEL.reply((Object)new Acknowledge(), supplier.get());
    }

    public Map<ResourceLocation, List<Pair<ResourceLocation, Integer>>> getKeyMap() {
        return this.keyMap;
    }
}

