/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.misc.concrete_hose;

import com.drmangotea.tfmg.content.machinery.misc.concrete_hose.ConcreteFillingBehavior;
import com.drmangotea.tfmg.content.machinery.misc.concrete_hose.ConcreteHoseFluidHandler;
import com.simibubi.create.content.fluids.hosePulley.HosePulleyBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import java.util.List;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ConcreteHoseBlockEntity
extends KineticBlockEntity {
    LerpedFloat offset = LerpedFloat.linear().startWithValue(0.0);
    boolean isMoving = true;
    public SmartFluidTank internalTank = new SmartFluidTank(1500, this::onTankContentsChanged);
    public LazyOptional<IFluidHandler> capability;
    public ConcreteFillingBehavior filler;
    public ConcreteHoseFluidHandler handler = new ConcreteHoseFluidHandler(this.internalTank, this.filler, () -> this.f_58858_.m_6625_((int)Math.ceil(this.offset.getValue())), () -> !this.isMoving);
    public boolean infinite;

    public ConcreteHoseBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.capability = LazyOptional.of(() -> this.handler);
    }

    public void sendData() {
        this.infinite = this.filler.isInfinite();
        super.sendData();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean addToGoggleTooltip = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (this.infinite) {
            TooltipHelper.addHint(tooltip, (String)"hint.hose_pulley", (Object[])new Object[0]);
        }
        return addToGoggleTooltip;
    }

    public float getInterpolatedOffset(float pt) {
        return this.offset.getValue(pt);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.filler = new ConcreteFillingBehavior((SmartBlockEntity)this);
        behaviours.add(this.filler);
        super.addBehaviours(behaviours);
    }

    protected void onTankContentsChanged(FluidStack contents) {
    }

    public void onSpeedChanged(float previousSpeed) {
        this.isMoving = true;
        if (this.getSpeed() == 0.0f) {
            this.offset.forceNextSync();
            this.offset.setValue((double)Math.round(this.offset.getValue()));
            this.isMoving = false;
        }
        if (this.isMoving) {
            float newOffset = this.offset.getValue() + this.getMovementSpeed();
            if (newOffset < 0.0f) {
                this.isMoving = false;
            }
            if (!this.f_58857_.m_8055_(this.f_58858_.m_6625_((int)Math.ceil(newOffset))).m_247087_()) {
                this.isMoving = false;
            }
            if (this.isMoving) {
                this.filler.reset();
            }
        }
        super.onSpeedChanged(previousSpeed);
    }

    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().m_82363_(0.0, (double)(-this.offset.getValue()), 0.0);
    }

    public void tick() {
        super.tick();
        float newOffset = this.offset.getValue() + this.getMovementSpeed();
        if (newOffset < 0.0f) {
            newOffset = 0.0f;
            this.isMoving = false;
        }
        if (!this.f_58857_.m_8055_(this.f_58858_.m_6625_((int)Math.ceil(newOffset))).m_247087_()) {
            newOffset = (int)newOffset;
            this.isMoving = false;
        }
        if (this.getSpeed() == 0.0f) {
            this.isMoving = false;
        }
        this.offset.setValue((double)newOffset);
        this.invalidateRenderBoundingBox();
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.isMoving) {
            return;
        }
        int ceil = (int)Math.ceil(this.offset.getValue() + this.getMovementSpeed());
        if (this.getMovementSpeed() > 0.0f && this.f_58857_.m_8055_(this.f_58858_.m_6625_(ceil)).m_247087_()) {
            this.isMoving = true;
            this.filler.reset();
            return;
        }
        this.sendData();
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        if (clientPacket) {
            this.offset.forceNextSync();
        }
        compound.m_128365_("Offset", (Tag)this.offset.writeNBT());
        compound.m_128365_("Tank", (Tag)this.internalTank.writeToNBT(new CompoundTag()));
        super.write(compound, clientPacket);
        if (clientPacket) {
            compound.m_128379_("Infinite", this.infinite);
        }
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.offset.readNBT(compound.m_128469_("Offset"), clientPacket);
        this.internalTank.readFromNBT(compound.m_128469_("Tank"));
        super.read(compound, clientPacket);
        if (clientPacket) {
            this.infinite = compound.m_128471_("Infinite");
        }
    }

    public void invalidate() {
        super.invalidate();
        this.capability.invalidate();
    }

    public float getMovementSpeed() {
        float movementSpeed = ConcreteHoseBlockEntity.convertToLinear((float)this.getSpeed());
        if (this.f_58857_.f_46443_) {
            movementSpeed *= ServerSpeedProvider.get();
        }
        return movementSpeed;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (this.isFluidHandlerCap(cap) && (side == null || HosePulleyBlock.hasPipeTowards((LevelReader)this.f_58857_, (BlockPos)this.f_58858_, (BlockState)this.m_58900_(), (Direction)side))) {
            return this.capability.cast();
        }
        return super.getCapability(cap, side);
    }
}

