/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.oil_processing.surface_scanner;

import com.drmangotea.tfmg.config.TFMGConfigs;
import com.drmangotea.tfmg.content.machinery.misc.machine_input.MachineInputBlockEntity;
import com.drmangotea.tfmg.registry.TFMGTags;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.phys.AABB;

public class SurfaceScannerBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    public Boolean[][] grid = new Boolean[5][5];

    public SurfaceScannerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(20);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        MachineInputBlockEntity be;
        CreateLang.translate((String)"goggles.surface_scanner.header", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_7495_());
        if (blockEntity instanceof MachineInputBlockEntity && Math.abs((be = (MachineInputBlockEntity)blockEntity).getSpeed()) >= 64.0f) {
            int depositsFound = 0;
            Boolean[][] booleanArray = this.grid;
            int n = booleanArray.length;
            for (int i = 0; i < n; ++i) {
                Boolean[] row;
                for (Boolean light : row = booleanArray[i]) {
                    if (!light.booleanValue()) continue;
                    ++depositsFound;
                }
            }
            if (depositsFound > 0) {
                CreateLang.number((double)depositsFound).add(CreateLang.translate((String)"goggles.surface_scanner.deposits_found", (Object[])new Object[0])).style(ChatFormatting.GREEN).forGoggles(tooltip);
            } else {
                CreateLang.translate((String)"goggles.surface_scanner.no_deposit", (Object[])new Object[0]).style(ChatFormatting.RED).forGoggles(tooltip);
            }
        } else {
            CreateLang.translate((String)"goggles.surface_scanner.no_rotation", (Object[])new Object[0]).style(ChatFormatting.DARK_RED).forGoggles(tooltip);
        }
        return true;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void findDeposits() {
        if (!this.f_58857_.f_46443_) {
            return;
        }
        for (int x = 0; x < 5; ++x) {
            for (int z = 0; z < 5; ++z) {
                this.grid[x][z] = this.hasOil(new BlockPos(this.m_58899_().m_123341_() + (x - 2) * 16, ((Integer)TFMGConfigs.common().machines.surfaceScannerScanDepth.get()).intValue(), this.m_58899_().m_123343_() + (z - 2) * 16));
            }
        }
    }

    public void lazyTick() {
        MachineInputBlockEntity be;
        super.lazyTick();
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_7495_());
        if (blockEntity instanceof MachineInputBlockEntity && Math.abs((be = (MachineInputBlockEntity)blockEntity).getSpeed()) >= 64.0f) {
            this.findDeposits();
        } else {
            this.grid = new Boolean[5][5];
        }
    }

    public boolean hasOil(BlockPos pos) {
        ChunkAccess chunk = this.f_58857_.m_46865_(pos);
        AABB checkedArea = new AABB(chunk.m_7697_().m_151394_(((Integer)TFMGConfigs.common().machines.surfaceScannerScanDepth.get()).intValue()).m_122012_().m_122024_());
        checkedArea = checkedArea.m_82377_(7.0, 0.0, 7.0);
        for (BlockState state : chunk.m_45556_(checkedArea).toList()) {
            if (!state.m_204336_(TFMGTags.TFMGBlockTags.SURFACE_SCANNER_FINDABLE.tag)) continue;
            return true;
        }
        return false;
    }
}

