/*
 * Decompiled with CFR 0.152.
 */
package extendedrenderer.particle.entity;

import com.corosus.coroutil.util.CoroUtilBlock;
import com.corosus.coroutil.util.CoroUtilMisc;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import extendedrenderer.particle.behavior.ParticleBehaviors;
import extendedrenderer.particle.entity.PivotingParticle;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import weather2.ClientTickHandler;
import weather2.IWindHandler;
import weather2.config.ConfigParticle;
import weather2.weathersystem.WeatherManagerClient;
import weather2.weathersystem.wind.WindManager;

@OnlyIn(value=Dist.CLIENT)
public class EntityRotFX
extends TextureSheetParticle
implements IWindHandler {
    public static final ParticleRenderType SORTED_TRANSLUCENT = new ParticleRenderType(){

        public void m_6505_(BufferBuilder p_217600_1_, TextureManager p_217600_2_) {
            RenderSystem.disableCull();
            ParticleRenderType.f_107431_.m_6505_(p_217600_1_, p_217600_2_);
        }

        public void m_6294_(Tesselator p_217599_1_) {
            ParticleRenderType.f_107431_.m_6294_(p_217599_1_);
        }

        public String toString() {
            return "PARTICLE_SHEET_SORTED_TRANSLUCENT";
        }
    };
    public static final ParticleRenderType SORTED_OPAQUE_BLOCK = new ParticleRenderType(){

        public void m_6505_(BufferBuilder p_217600_1_, TextureManager p_217600_2_) {
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShader(GameRenderer::m_172829_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118259_);
            p_217600_1_.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
        }

        public void m_6294_(Tesselator p_217599_1_) {
            ParticleRenderType.f_107430_.m_6294_(p_217599_1_);
        }

        public String toString() {
            return "PARTICLE_BLOCK_SHEET_SORTED_OPAQUE";
        }
    };
    public boolean weatherEffect = false;
    public float spawnY = -1.0f;
    public int particleTextureIndexInt = 0;
    public float brightness = 0.7f;
    public boolean callUpdateSuper = true;
    public boolean callUpdatePB = true;
    public float renderRange = 128.0f;
    public int renderOrder = 0;
    private int entityID = 0;
    public int debugID = 0;
    public float prevRotationYaw;
    public float rotationYaw;
    public float prevRotationPitch;
    public float rotationPitch;
    public float windWeight = 5.0f;
    public boolean isTransparent = true;
    public boolean killOnCollide = false;
    public int killOnCollideActivateAtAge = 0;
    public boolean facePlayer = false;
    public boolean facePlayerYaw = false;
    public boolean vanillaMotionDampen = true;
    public double aboveGroundHeight = 4.5;
    public boolean checkAheadToBounce = true;
    public boolean collisionSpeedDampen = true;
    public double bounceSpeed = 0.05;
    public double bounceSpeedMax = 0.15;
    public double bounceSpeedAhead = 0.35;
    public double bounceSpeedMaxAhead = 0.25;
    public boolean bounceOnVerticalImpact = false;
    public double bounceOnVerticalImpactEnergy = 0.3f;
    public boolean spinFast = false;
    public float spinFastRate = 10.0f;
    public boolean spinTowardsMotionDirection = false;
    private float ticksFadeInMax = 0.0f;
    private float ticksFadeOutMax = 0.0f;
    private float fullAlphaTarget = 1.0f;
    private boolean dontRenderUnderTopmostBlock = false;
    private boolean killWhenUnderTopmostBlock = false;
    private int killWhenUnderTopmostBlock_ScanAheadRange = 0;
    public int killWhenUnderCameraAtLeast = 0;
    public int killWhenFarFromCameraAtLeast = 0;
    private float ticksFadeOutMaxOnDeath = -1.0f;
    private float ticksFadeOutCurOnDeath = 0.0f;
    protected boolean fadingOut = false;
    public float avoidTerrainAngle = 0.0f;
    public boolean useRotationAroundCenter = false;
    public float rotationAroundCenter = 0.0f;
    public float rotationAroundCenterPrev = 0.0f;
    public float rotationSpeedAroundCenter = 0.0f;
    public float rotationDistAroundCenter = 0.0f;
    private boolean slantParticleToWind = false;
    public boolean quatControl = false;
    public boolean fastLight = false;
    public float brightnessCache = 0.5f;
    public boolean rotateOrderXY = false;
    public float extraYRotation = 0.0f;
    public boolean markCollided = false;
    public boolean isCollidedHorizontally = false;
    public boolean isCollidedVerticallyDownwards = false;
    public boolean isCollidedVerticallyUpwards = false;
    public Vector3f rotationAround = new Vector3f();
    protected int lastNonZeroBrightness = 0xF00000;
    public ParticleBehaviors pb = null;
    private boolean useCustomBBForRenderCulling = false;
    private static final AABB INITIAL_AABB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private AABB bbRender = INITIAL_AABB;
    private float renderDistanceCull = -1.0f;
    private boolean useDynamicWindSpeed = true;

    public EntityRotFX(ClientLevel par1World, double par2, double par4, double par6, double par8, double par10, double par12) {
        super(par1World, par2, par4, par6, par8, par10, par12);
        this.m_107250_(0.3f, 0.3f);
        this.entityID = CoroUtilMisc.random.nextInt(100000);
    }

    public boolean isSlantParticleToWind() {
        return this.slantParticleToWind;
    }

    public void setSlantParticleToWind(boolean slantParticleToWind) {
        this.slantParticleToWind = slantParticleToWind;
    }

    public float getTicksFadeOutMaxOnDeath() {
        return this.ticksFadeOutMaxOnDeath;
    }

    public void setTicksFadeOutMaxOnDeath(float ticksFadeOutMaxOnDeath) {
        this.ticksFadeOutMaxOnDeath = ticksFadeOutMaxOnDeath;
    }

    public boolean isKillWhenUnderTopmostBlock() {
        return this.killWhenUnderTopmostBlock;
    }

    public void setKillWhenUnderTopmostBlock(boolean killWhenUnderTopmostBlock) {
        this.killWhenUnderTopmostBlock = killWhenUnderTopmostBlock;
    }

    public boolean isDontRenderUnderTopmostBlock() {
        return this.dontRenderUnderTopmostBlock;
    }

    public void setDontRenderUnderTopmostBlock(boolean dontRenderUnderTopmostBlock) {
        this.dontRenderUnderTopmostBlock = dontRenderUnderTopmostBlock;
    }

    public float getTicksFadeInMax() {
        return this.ticksFadeInMax;
    }

    public void setTicksFadeInMax(float ticksFadeInMax) {
        this.ticksFadeInMax = ticksFadeInMax;
    }

    public float getTicksFadeOutMax() {
        return this.ticksFadeOutMax;
    }

    public void setTicksFadeOutMax(float ticksFadeOutMax) {
        this.ticksFadeOutMax = ticksFadeOutMax;
    }

    public int getParticleTextureIndex() {
        return this.particleTextureIndexInt;
    }

    public void m_107257_(int par) {
        this.f_107225_ = par;
    }

    public float getAlphaF() {
        return this.f_107230_;
    }

    public void m_107274_() {
        if (this.pb != null) {
            this.pb.particles.remove(this);
        }
        super.m_107274_();
    }

    public void m_5989_() {
        super.m_5989_();
        this.prevRotationPitch = this.rotationPitch;
        if (!(this instanceof PivotingParticle)) {
            this.prevRotationYaw = this.rotationYaw;
        }
        Entity ent = Minecraft.m_91087_().m_91288_();
        if (!this.isVanillaMotionDampen()) {
            this.f_107215_ /= (double)0.98f;
            this.f_107216_ /= (double)0.98f;
            this.f_107217_ /= (double)0.98f;
        }
        if (!this.f_107220_ && !this.fadingOut) {
            int height;
            if (this.killOnCollide && (this.killOnCollideActivateAtAge == 0 || this.f_107224_ >= this.killOnCollideActivateAtAge) && this.isCollided()) {
                this.startDeath();
            }
            BlockPos pos = CoroUtilBlock.blockPos((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_);
            if (this.killWhenUnderTopmostBlock && this.f_107213_ - (double)this.killWhenUnderTopmostBlock_ScanAheadRange <= (double)(height = this.f_107208_.m_5452_(Heightmap.Types.MOTION_BLOCKING, pos).m_123342_())) {
                this.startDeath();
            }
            if (this.killWhenUnderCameraAtLeast != 0 && this.f_107213_ < ent.m_20186_() - (double)this.killWhenUnderCameraAtLeast) {
                this.startDeath();
            }
            if (this.killWhenFarFromCameraAtLeast != 0 && this.getAge() > 20 && this.getAge() % 5 == 0 && ent.m_20275_(this.f_107212_, this.f_107213_, this.f_107214_) > (double)(this.killWhenFarFromCameraAtLeast * this.killWhenFarFromCameraAtLeast)) {
                this.startDeath();
            }
        }
        if (!this.collisionSpeedDampen && this.f_107218_) {
            this.f_107215_ /= (double)0.7f;
            this.f_107217_ /= (double)0.7f;
        }
        double speedXZ = Math.sqrt(this.getMotionX() * this.getMotionX() + this.getMotionZ() * this.getMotionZ());
        double spinFastRateAdj = (double)this.spinFastRate * speedXZ * 10.0;
        if (this.spinFast) {
            this.rotationPitch = (float)((double)this.rotationPitch + (this.entityID % 2 == 0 ? spinFastRateAdj : -spinFastRateAdj));
            this.rotationYaw = (float)((double)this.rotationYaw + (this.entityID % 2 == 0 ? -spinFastRateAdj : spinFastRateAdj));
        }
        float angleToMovement = (float)Math.toDegrees(Math.atan2(this.f_107215_, this.f_107217_));
        if (this.spinTowardsMotionDirection) {
            this.rotationYaw = angleToMovement;
            this.rotationPitch += this.spinFastRate;
        }
        if (!this.fadingOut) {
            if (this.ticksFadeInMax > 0.0f && (float)this.getAge() < this.ticksFadeInMax) {
                this.m_107271_((float)this.getAge() / this.ticksFadeInMax * this.getFullAlphaTarget());
            } else if (this.ticksFadeOutMax > 0.0f && (float)this.getAge() > (float)this.m_107273_() - this.ticksFadeOutMax) {
                float count = (float)this.getAge() - ((float)this.m_107273_() - this.ticksFadeOutMax);
                float val = (this.ticksFadeOutMax - count) / this.ticksFadeOutMax;
                this.m_107271_(val * this.getFullAlphaTarget());
            } else if (this.ticksFadeInMax > 0.0f || this.ticksFadeOutMax > 0.0f) {
                this.m_107271_(this.getFullAlphaTarget());
            }
        } else {
            if (this.ticksFadeOutCurOnDeath < this.ticksFadeOutMaxOnDeath) {
                this.ticksFadeOutCurOnDeath += 1.0f;
            } else {
                this.m_107274_();
            }
            float val = 1.0f - this.ticksFadeOutCurOnDeath / this.ticksFadeOutMaxOnDeath;
            this.m_107271_(val * this.getFullAlphaTarget());
        }
        if (this.f_107208_.m_46467_() % 5L == 0L) {
            // empty if block
        }
        this.rotationAroundCenter += this.rotationSpeedAroundCenter;
        this.rotationAroundCenter %= 360.0f;
        this.tickExtraRotations();
    }

    public void tickExtraRotations() {
        WeatherManagerClient weatherMan;
        if (this.slantParticleToWind) {
            double motionXZ = Math.sqrt(this.f_107215_ * this.f_107215_ + this.f_107217_ * this.f_107217_);
            this.rotationPitch = (float)Math.atan2(this.f_107216_, motionXZ);
        }
        if ((weatherMan = ClientTickHandler.weatherManager) == null) {
            return;
        }
        WindManager windMan = weatherMan.getWindManager();
        if (windMan == null) {
            return;
        }
        if (this instanceof PivotingParticle) {
            return;
        }
        if (this.f_107218_) {
            windMan.applyWindForceNew(this, 0.015000001f, 0.5f, this.useDynamicWindSpeed);
        } else {
            windMan.applyWindForceNew(this, 0.05f, 0.5f, this.useDynamicWindSpeed);
        }
    }

    public void startDeath() {
        if (this.ticksFadeOutMaxOnDeath > 0.0f) {
            this.ticksFadeOutCurOnDeath = 0.0f;
            this.fadingOut = true;
        } else {
            this.m_107274_();
        }
    }

    public void spawnAsWeatherEffect() {
        this.weatherEffect = true;
        if (ConfigParticle.Particle_engine_weather2) {
            ClientTickHandler.particleManagerExtended().add((Particle)this);
        } else {
            Minecraft.m_91087_().f_91061_.m_107344_((Particle)this);
        }
    }

    public int getAge() {
        return this.f_107224_;
    }

    public void setAge(int age) {
        this.f_107224_ = age;
    }

    public int m_107273_() {
        return this.f_107225_;
    }

    public void m_107250_(float par1, float par2) {
        super.m_107250_(par1, par2);
        this.m_107264_(this.f_107212_, this.f_107213_, this.f_107214_);
    }

    public void setGravity(float par) {
        this.f_107226_ = par;
    }

    public float maxRenderRange() {
        return this.renderRange;
    }

    public void setScale(float parScale) {
        this.setSizeForRenderCulling(parScale, parScale);
        this.f_107663_ = parScale;
    }

    public Vector3f getPosition() {
        return new Vector3f((float)this.f_107212_, (float)this.f_107213_, (float)this.f_107214_);
    }

    public float getScale() {
        return this.f_107663_;
    }

    public Vec3 getPos() {
        return new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
    }

    public double getPosX() {
        return this.f_107212_;
    }

    public void setPosX(double posX) {
        this.f_107212_ = posX;
    }

    public double getPosY() {
        return this.f_107213_;
    }

    public void setPosY(double posY) {
        this.f_107213_ = posY;
    }

    public double getPosZ() {
        return this.f_107214_;
    }

    public void setPosZ(double posZ) {
        this.f_107214_ = posZ;
    }

    public double getMotionX() {
        return this.f_107215_;
    }

    public void setMotionX(double motionX) {
        this.f_107215_ = motionX;
    }

    public double getMotionY() {
        return this.f_107216_;
    }

    public void setMotionY(double motionY) {
        this.f_107216_ = motionY;
    }

    public double getMotionZ() {
        return this.f_107217_;
    }

    public void setMotionZ(double motionZ) {
        this.f_107217_ = motionZ;
    }

    public double getPrevPosX() {
        return this.f_107209_;
    }

    public void setPrevPosX(double prevPosX) {
        this.f_107209_ = prevPosX;
    }

    public double getPrevPosY() {
        return this.f_107210_;
    }

    public void setPrevPosY(double prevPosY) {
        this.f_107210_ = prevPosY;
    }

    public double getPrevPosZ() {
        return this.f_107211_;
    }

    public void setPrevPosZ(double prevPosZ) {
        this.f_107211_ = prevPosZ;
    }

    public int getEntityId() {
        return this.entityID;
    }

    public Level getWorld() {
        return this.f_107208_;
    }

    public void setCanCollide(boolean val) {
        this.f_107219_ = val;
    }

    public boolean getCanCollide() {
        return this.f_107219_;
    }

    public boolean isCollided() {
        return this.f_107218_ || this.isCollidedHorizontally;
    }

    public double getDistance(double x, double y, double z) {
        double d0 = this.f_107212_ - x;
        double d1 = this.f_107213_ - y;
        double d2 = this.f_107214_ - z;
        return Mth.m_14116_((float)((float)(d0 * d0 + d1 * d1 + d2 * d2)));
    }

    public float m_5902_(float scaleFactor) {
        return this.f_107663_;
    }

    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        Quaternionf quaternion;
        Vec3 Vector3d = renderInfo.m_90583_();
        Vec3 pivotedPosition = this.getPivotedPosition(partialTicks);
        float f = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) + pivotedPosition.f_82479_ - Vector3d.m_7096_());
        float f1 = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) + pivotedPosition.f_82480_ - Vector3d.m_7098_());
        float f2 = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) + pivotedPosition.f_82481_ - Vector3d.m_7094_());
        if (this.facePlayer || this.rotationPitch == 0.0f && this.rotationYaw == 0.0f) {
            quaternion = renderInfo.m_253121_();
        } else {
            quaternion = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
            if (this.facePlayerYaw) {
                quaternion.mul((Quaternionfc)Axis.f_252436_.m_252977_(-renderInfo.m_90590_()));
            } else {
                quaternion.mul((Quaternionfc)Axis.f_252436_.m_252977_(Mth.m_14179_((float)partialTicks, (float)this.prevRotationYaw, (float)this.rotationYaw)));
            }
            quaternion.mul((Quaternionfc)Axis.f_252529_.m_252977_(Mth.m_14179_((float)partialTicks, (float)this.prevRotationPitch, (float)this.rotationPitch)));
        }
        if (this.f_107231_ == 0.0f) {
            quaternionf = renderInfo.m_253121_();
        } else {
            quaternionf = new Quaternionf((Quaternionfc)renderInfo.m_253121_());
            quaternionf.rotateZ(Mth.m_14179_((float)partialTicks, (float)this.f_107204_, (float)this.f_107231_));
        }
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f4 = this.m_5902_(partialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.rotate((Quaternionfc)quaternion);
            vector3f.mul(f4);
            vector3f.add(f, f1, f2);
        }
        float f7 = this.m_5970_();
        float f8 = this.m_5952_();
        float f5 = this.m_5951_();
        float f6 = this.m_5950_();
        int j = this.m_6355_(partialTicks);
        if (j > 0) {
            this.lastNonZeroBrightness = j;
        } else {
            j = this.lastNonZeroBrightness;
        }
        buffer.m_5483_((double)avector3f[0].x(), (double)avector3f[0].y(), (double)avector3f[0].z()).m_7421_(f8, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        buffer.m_5483_((double)avector3f[1].x(), (double)avector3f[1].y(), (double)avector3f[1].z()).m_7421_(f8, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        buffer.m_5483_((double)avector3f[2].x(), (double)avector3f[2].y(), (double)avector3f[2].z()).m_7421_(f7, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        buffer.m_5483_((double)avector3f[3].x(), (double)avector3f[3].y(), (double)avector3f[3].z()).m_7421_(f7, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
    }

    public void setKillOnCollide(boolean val) {
        this.killOnCollide = val;
    }

    public void m_6257_(double x, double y, double z) {
        double xx = x;
        double yy = y;
        double zz = z;
        if (this.f_107219_ && (x != 0.0 || y != 0.0 || z != 0.0)) {
            Vec3 Vector3d = Entity.m_198894_(null, (Vec3)new Vec3(x, y, z), (AABB)this.m_107277_(), (Level)this.f_107208_, List.of());
            x = Vector3d.f_82479_;
            y = Vector3d.f_82480_;
            z = Vector3d.f_82481_;
        }
        if (x != 0.0 || y != 0.0 || z != 0.0) {
            this.m_107259_(this.m_107277_().m_82386_(x, y, z));
            if (this.isUseCustomBBForRenderCulling()) {
                this.setBoundingBoxForRender(this.getBoundingBoxForRender(1.0f).m_82386_(x, y, z));
            }
            this.m_107275_();
        }
        this.f_107218_ = yy != y && yy < 0.0;
        this.isCollidedHorizontally = xx != x || zz != z;
        this.isCollidedVerticallyDownwards = yy < y;
        boolean bl = this.isCollidedVerticallyUpwards = yy > y;
        if (xx != x) {
            this.f_107215_ = 0.0;
        }
        if (zz != z) {
            this.f_107217_ = 0.0;
        }
        if (!this.markCollided) {
            if (this.f_107218_ || this.isCollidedVerticallyDownwards || this.isCollidedHorizontally || this.isCollidedVerticallyUpwards) {
                this.onHit();
                this.markCollided = true;
            }
            if (this.bounceOnVerticalImpact && (this.f_107218_ || this.isCollidedVerticallyDownwards)) {
                this.setMotionY(-this.getMotionY() * this.bounceOnVerticalImpactEnergy);
            }
        }
    }

    public void setFacePlayer(boolean val) {
        this.facePlayer = val;
    }

    public TextureAtlasSprite getParticleTexture() {
        return this.f_108321_;
    }

    public boolean isVanillaMotionDampen() {
        return this.vanillaMotionDampen;
    }

    public void setVanillaMotionDampen(boolean motionDampen) {
        this.vanillaMotionDampen = motionDampen;
    }

    public int m_6355_(float p_189214_1_) {
        return super.m_6355_(p_189214_1_);
    }

    public void m_107253_(float particleRedIn, float particleGreenIn, float particleBlueIn) {
        super.m_107253_(particleRedIn, particleGreenIn, particleBlueIn);
    }

    public void m_107271_(float alpha) {
        super.m_107271_(alpha);
    }

    public int getKillWhenUnderTopmostBlock_ScanAheadRange() {
        return this.killWhenUnderTopmostBlock_ScanAheadRange;
    }

    public void setKillWhenUnderTopmostBlock_ScanAheadRange(int killWhenUnderTopmostBlock_ScanAheadRange) {
        this.killWhenUnderTopmostBlock_ScanAheadRange = killWhenUnderTopmostBlock_ScanAheadRange;
    }

    public boolean isCollidedVertically() {
        return this.isCollidedVerticallyDownwards || this.isCollidedVerticallyUpwards;
    }

    public ParticleRenderType m_7556_() {
        return SORTED_TRANSLUCENT;
    }

    public void m_108337_(TextureAtlasSprite sprite) {
        super.m_108337_(sprite);
    }

    public TextureAtlasSprite getSprite() {
        return this.f_108321_;
    }

    public float getFullAlphaTarget() {
        return this.fullAlphaTarget;
    }

    public void setFullAlphaTarget(float fullAlphaTarget) {
        this.fullAlphaTarget = fullAlphaTarget;
    }

    public int getLastNonZeroBrightness() {
        return this.lastNonZeroBrightness;
    }

    public void setLastNonZeroBrightness(int lastNonZeroBrightness) {
        this.lastNonZeroBrightness = lastNonZeroBrightness;
    }

    public void onHit() {
    }

    public void setMaxAge(int par) {
        this.m_107257_(par);
    }

    public int getMaxAge() {
        return this.m_107273_();
    }

    public void setAlphaF(float val) {
        this.m_107271_(val);
    }

    public void setPosition(double posX, double posY, double posZ) {
        this.m_107264_(posX, posY, posZ);
    }

    public Vec3 getPivotedPosition(float partialTicks) {
        return Vec3.f_82478_;
    }

    public void setBoundingBoxForRender(AABB p_107260_) {
        this.bbRender = p_107260_;
    }

    public AABB getBoundingBoxForRender(float partialTicks) {
        if (this.isUseCustomBBForRenderCulling()) {
            return this.bbRender;
        }
        return this.m_107277_();
    }

    public void setSizeForRenderCulling(float p_107251_, float p_107252_) {
        if (p_107251_ != this.f_107221_ || p_107252_ != this.f_107222_) {
            this.f_107221_ = p_107251_;
            this.f_107222_ = p_107252_;
            AABB aabb = this.m_107277_();
            double d0 = (aabb.f_82288_ + aabb.f_82291_ - (double)p_107251_) / 2.0;
            double d1 = (aabb.f_82290_ + aabb.f_82293_ - (double)p_107251_) / 2.0;
            this.setBoundingBoxForRender(new AABB(d0, aabb.f_82289_, d1, d0 + (double)this.f_107221_, aabb.f_82289_ + (double)this.f_107222_, d1 + (double)this.f_107221_));
        }
    }

    public boolean isUseCustomBBForRenderCulling() {
        return this.useCustomBBForRenderCulling;
    }

    public void setUseCustomBBForRenderCulling(boolean useCustomBBForRenderCulling) {
        this.useCustomBBForRenderCulling = useCustomBBForRenderCulling;
    }

    @Override
    public float getWindWeight() {
        return this.windWeight;
    }

    @Override
    public int getParticleDecayExtra() {
        return 0;
    }

    public int getKillOnCollideActivateAtAge() {
        return this.killOnCollideActivateAtAge;
    }

    public void setKillOnCollideActivateAtAge(int killOnCollideActivateAtAge) {
        this.killOnCollideActivateAtAge = killOnCollideActivateAtAge;
    }

    public float getRenderDistanceCull() {
        return this.renderDistanceCull;
    }

    public void setRenderDistanceCull(float renderDistanceCull) {
        this.renderDistanceCull = renderDistanceCull;
    }

    public boolean isUseDynamicWindSpeed() {
        return this.useDynamicWindSpeed;
    }

    public void setUseDynamicWindSpeed(boolean useDynamicWindSpeed) {
        this.useDynamicWindSpeed = useDynamicWindSpeed;
    }
}

