/*
 * Decompiled with CFR 0.152.
 */
package weather2.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import weather2.WeatherBlocks;
import weather2.util.WeatherUtilEntity;
import weather2.util.WindReader;

public class AnemometerBlockEntity
extends BlockEntity {
    public float smoothAngle = 0.0f;
    public float smoothAnglePrev = 0.0f;
    public float smoothAngleRotationalVel = 0.0f;
    public boolean isOutsideCached = false;

    public AnemometerBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)WeatherBlocks.BLOCK_ENTITY_ANEMOMETER.get(), p_155229_, p_155230_);
    }

    public void m_142339_(Level level) {
        super.m_142339_(level);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AnemometerBlockEntity entity) {
        entity.tick(level, pos, state);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (level.f_46443_) {
            if (level.m_46467_() % 40L == 0L) {
                this.isOutsideCached = WeatherUtilEntity.isPosOutside(level, new Vec3((double)((float)this.m_58899_().m_123341_() + 0.5f), (double)((float)this.m_58899_().m_123342_() + 0.5f), (double)((float)this.m_58899_().m_123343_() + 0.5f)), false, true);
            }
            if (this.isOutsideCached) {
                float rotMax;
                float windSpeed = WindReader.getWindSpeed(level, pos, 1.0f);
                float maxSpeed = windSpeed / 1.2f * (rotMax = 50.0f);
                if (this.smoothAngleRotationalVel < maxSpeed) {
                    this.smoothAngleRotationalVel += windSpeed * 0.3f;
                }
                if (this.smoothAngleRotationalVel > rotMax) {
                    this.smoothAngleRotationalVel = rotMax;
                }
                if (this.smoothAngle >= 180.0f) {
                    this.smoothAngle -= 360.0f;
                }
            }
            this.smoothAnglePrev = this.smoothAngle;
            this.smoothAngle += this.smoothAngleRotationalVel;
            this.smoothAngleRotationalVel -= 0.01f;
            this.smoothAngleRotationalVel *= 0.99f;
            if (this.smoothAngleRotationalVel <= 0.0f) {
                this.smoothAngleRotationalVel = 0.0f;
            }
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
    }
}

