/*
 * Decompiled with CFR 0.152.
 */
package weather2.command;

import com.corosus.coroutil.util.CoroUtilBlock;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import weather2.ServerTickHandler;
import weather2.config.ConfigMisc;
import weather2.config.ConfigWind;
import weather2.config.WeatherUtilConfig;
import weather2.util.WeatherUtil;
import weather2.weathersystem.WeatherManagerServer;
import weather2.weathersystem.storm.StormObject;
import weather2.weathersystem.storm.WeatherObjectParticleStorm;

public class WeatherCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"weather2").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"kill_all_storms").requires(s -> s.m_6761_(2))).executes(c -> {
            WeatherManagerServer wm = ServerTickHandler.getWeatherManagerFor((ResourceKey<Level>)((CommandSourceStack)c.getSource()).m_81372_().m_46472_());
            wm.clearAllStorms();
            ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)"Killed all storms"), true);
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"debug").requires(s -> s.m_6761_(2))).then(Commands.m_82127_((String)"print_grab_list").executes(c -> {
            WeatherUtil.testAllBlocks();
            ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)"Tornado grab list printed to debug.log"), true);
            return 1;
        }))).then(Commands.m_82127_((String)"storm_chance").executes(c -> {
            WeatherManagerServer wm = ServerTickHandler.getWeatherManagerFor((ResourceKey<Level>)((CommandSourceStack)c.getSource()).m_81372_().m_46472_());
            float chance = wm.getBiomeBasedStormSpawnChanceInArea(CoroUtilBlock.blockPos((double)((CommandSourceStack)c.getSource()).m_81371_().f_82479_, (double)((CommandSourceStack)c.getSource()).m_81371_().f_82480_, (double)((CommandSourceStack)c.getSource()).m_81371_().f_82481_));
            ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)("Likelyhood of storms to spawn here within 1024 blocks: " + chance * 100.0f)), true);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"wind_event").requires(s -> s.m_6761_(2))).then(Commands.m_82127_((String)"clear").executes(c -> {
            WeatherManagerServer wm = ServerTickHandler.getWeatherManagerFor((ResourceKey<Level>)((CommandSourceStack)c.getSource()).m_81372_().m_46472_());
            wm.getWindManager().stopLowWindEvent();
            wm.getWindManager().stopHighWindEvent();
            ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)"Stopped any active high or low wind events"), true);
            return 1;
        }))).then(Commands.m_82127_((String)"high").executes(c -> {
            WeatherManagerServer wm = ServerTickHandler.getWeatherManagerFor((ResourceKey<Level>)((CommandSourceStack)c.getSource()).m_81372_().m_46472_());
            wm.getWindManager().stopLowWindEvent();
            wm.getWindManager().startHighWindEvent();
            ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)"Started high wind event"), true);
            return 1;
        }))).then(Commands.m_82127_((String)"low").executes(c -> {
            WeatherManagerServer wm = ServerTickHandler.getWeatherManagerFor((ResourceKey<Level>)((CommandSourceStack)c.getSource()).m_81372_().m_46472_());
            wm.getWindManager().stopHighWindEvent();
            wm.getWindManager().startLowWindEvent();
            wm.getWindManager().windSpeedGlobal = (float)(ConfigWind.windSpeedMin + (double)0.2f);
            ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)"Started low wind event"), true);
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"wind_angle").requires(s -> s.m_6761_(2))).then(Commands.m_82129_((String)"angle", (ArgumentType)IntegerArgumentType.integer((int)0, (int)359)).executes(c -> {
            int angle = IntegerArgumentType.getInteger((CommandContext)c, (String)"angle");
            WeatherManagerServer wm = ServerTickHandler.getWeatherManagerFor((ResourceKey<Level>)((CommandSourceStack)c.getSource()).m_81372_().m_46472_());
            wm.getWindManager().windAngleGlobal = angle;
            ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)("Set wind angle for clouds to " + angle)), true);
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"wind_speed").requires(s -> s.m_6761_(2))).then(Commands.m_82129_((String)"speed", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.5f)).executes(c -> {
            float speed = FloatArgumentType.getFloat((CommandContext)c, (String)"speed");
            WeatherManagerServer wm = ServerTickHandler.getWeatherManagerFor((ResourceKey<Level>)((CommandSourceStack)c.getSource()).m_81372_().m_46472_());
            wm.getWindManager().windSpeedGlobal = speed;
            ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)("Set wind speed for clouds to " + speed)), true);
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"server_precipitation").requires(s -> s.m_6761_(2))).then(Commands.m_82129_((String)"amount", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(c -> {
            float amount = FloatArgumentType.getFloat((CommandContext)c, (String)"amount");
            WeatherManagerServer wm = ServerTickHandler.getWeatherManagerFor((ResourceKey<Level>)((CommandSourceStack)c.getSource()).m_81372_().m_46472_());
            wm.vanillaRainAmountOnServer = amount;
            if (ConfigMisc.overcastMode) {
                ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)("Server precipitation amount set to " + amount)), true);
            } else {
                ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)"overcastMode not on, this will change nothing"), true);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"summon").requires(s -> s.m_6761_(2))).requires(s -> WeatherUtilConfig.listDimensionsWeather.contains(s.m_81372_().m_46472_().m_135782_().toString()))).then(Commands.m_82127_((String)"storm_rain").executes(c -> {
            StormObject stormObject = WeatherCommand.summonStorm((CommandContext<CommandSourceStack>)c, StormObject.STATE_NORMAL);
            ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)"Summoned rain storm"), true);
            return 1;
        }))).then(Commands.m_82127_((String)"storm_lightning").executes(c -> {
            StormObject stormObject = WeatherCommand.summonStorm((CommandContext<CommandSourceStack>)c, StormObject.STATE_THUNDER);
            stormObject.initRealStorm(null, null);
            stormObject.levelCurIntensityStage = StormObject.STATE_THUNDER;
            stormObject.levelStormIntensityMax = StormObject.STATE_THUNDER;
            ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)"Summoned lightning storm"), true);
            return 1;
        }))).then(Commands.m_82127_((String)"storm_highwind").executes(c -> {
            StormObject stormObject = WeatherCommand.summonStorm((CommandContext<CommandSourceStack>)c, StormObject.STATE_HIGHWIND);
            stormObject.initRealStorm(null, null);
            stormObject.levelCurIntensityStage = StormObject.STATE_HIGHWIND;
            stormObject.levelStormIntensityMax = StormObject.STATE_HIGHWIND;
            ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)"Summoned highwind storm"), true);
            return 1;
        }))).then(Commands.m_82127_((String)"storm_hail").executes(c -> {
            StormObject stormObject = WeatherCommand.summonStorm((CommandContext<CommandSourceStack>)c, StormObject.STATE_HAIL);
            stormObject.initRealStorm(null, null);
            stormObject.levelCurIntensityStage = StormObject.STATE_HAIL;
            stormObject.levelStormIntensityMax = StormObject.STATE_HAIL;
            ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)"Summoned hail storm"), true);
            return 1;
        }))).then(Commands.m_82127_((String)"tornado_f0").executes(c -> {
            StormObject stormObject = WeatherCommand.summonStorm((CommandContext<CommandSourceStack>)c, StormObject.STATE_FORMING);
            stormObject.levelStormIntensityMax = StormObject.STATE_STAGE1;
            ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)"Summoned forming tornado"), true);
            return 1;
        }))).then(Commands.m_82127_((String)"tornado_f1").executes(c -> {
            StormObject stormObject = WeatherCommand.summonStorm((CommandContext<CommandSourceStack>)c, StormObject.STATE_STAGE1);
            ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)"Summoned f1 tornado"), true);
            return 1;
        }))).then(Commands.m_82127_((String)"tornado_f2").executes(c -> {
            StormObject stormObject = WeatherCommand.summonStorm((CommandContext<CommandSourceStack>)c, StormObject.STATE_STAGE2);
            ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)"Summoned f2 tornado"), true);
            return 1;
        }))).then(Commands.m_82127_((String)"tornado_f3").executes(c -> {
            StormObject stormObject = WeatherCommand.summonStorm((CommandContext<CommandSourceStack>)c, StormObject.STATE_STAGE3);
            ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)"Summoned f3 tornado"), true);
            return 1;
        }))).then(Commands.m_82127_((String)"tornado_f4").executes(c -> {
            StormObject stormObject = WeatherCommand.summonStorm((CommandContext<CommandSourceStack>)c, StormObject.STATE_STAGE4);
            ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)"Summoned f4 tornado"), true);
            return 1;
        }))).then(Commands.m_82127_((String)"sharknado").executes(c -> {
            StormObject stormObject = WeatherCommand.summonStorm((CommandContext<CommandSourceStack>)c, StormObject.STATE_STAGE1);
            stormObject.levelStormIntensityMax = StormObject.STATE_STAGE4;
            stormObject.setSharknado(true);
            ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)"Summoned sharknado"), true);
            return 1;
        }))).then(Commands.m_82127_((String)"firenado_f0").executes(c -> {
            StormObject stormObject = WeatherCommand.summonStorm((CommandContext<CommandSourceStack>)c, StormObject.STATE_FORMING);
            stormObject.levelStormIntensityMax = StormObject.STATE_STAGE4;
            stormObject.isFirenado = true;
            ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)"Summoned firenado"), true);
            return 1;
        }))).then(Commands.m_82127_((String)"firenado_f1").executes(c -> {
            StormObject stormObject = WeatherCommand.summonStorm((CommandContext<CommandSourceStack>)c, StormObject.STATE_STAGE1);
            stormObject.levelStormIntensityMax = StormObject.STATE_STAGE4;
            stormObject.isFirenado = true;
            ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)"Summoned firenado"), true);
            return 1;
        }))).then(Commands.m_82127_((String)"tornado_player").executes(c -> {
            StormObject stormObject = WeatherCommand.summonStorm((CommandContext<CommandSourceStack>)c, StormObject.STATE_STAGE1);
            stormObject.setupPlayerControlledTornado(((CommandSourceStack)c.getSource()).m_81373_());
            stormObject.setPlayerControlledTimeLeft(600);
            ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)"Summoned player tornado"), true);
            return 1;
        }))).then(Commands.m_82127_((String)"tornado_f0_max").executes(c -> {
            StormObject stormObject = WeatherCommand.summonStorm((CommandContext<CommandSourceStack>)c, StormObject.STATE_FORMING);
            stormObject.levelStormIntensityMax = StormObject.STATE_FORMING;
            stormObject.alwaysProgresses = false;
            ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)"Summoned tornado"), true);
            return 1;
        }))).then(Commands.m_82127_((String)"sandstorm_try").executes(c -> {
            WeatherManagerServer wm = ServerTickHandler.getWeatherManagerFor((ResourceKey<Level>)((CommandSourceStack)c.getSource()).m_81372_().m_46472_());
            boolean sandstormMade = wm.trySpawnParticleStormNearPos((Level)((CommandSourceStack)c.getSource()).m_81372_(), ((CommandSourceStack)c.getSource()).m_81371_(), WeatherObjectParticleStorm.StormType.SANDSTORM);
            if (sandstormMade) {
                ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)"Summoned sandstorm"), true);
                wm.getWindManager().stopLowWindEvent();
                wm.getWindManager().startHighWindEvent();
            } else {
                ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)"Couldn't spawn, try being in a large desert"), true);
            }
            return 1;
        }))).then(Commands.m_82127_((String)"snowstorm_try").executes(c -> {
            WeatherManagerServer wm = ServerTickHandler.getWeatherManagerFor((ResourceKey<Level>)((CommandSourceStack)c.getSource()).m_81372_().m_46472_());
            boolean sandstormMade = wm.trySpawnParticleStormNearPos((Level)((CommandSourceStack)c.getSource()).m_81372_(), ((CommandSourceStack)c.getSource()).m_81371_(), WeatherObjectParticleStorm.StormType.SNOWSTORM);
            if (sandstormMade) {
                ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)"Summoned snowstorm"), true);
                wm.getWindManager().stopLowWindEvent();
                wm.getWindManager().startHighWindEvent();
            } else {
                ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)"Couldn't spawn, try being in a large snowy area"), true);
            }
            return 1;
        }))).then(Commands.m_82127_((String)"sandstorm_force").executes(c -> {
            WeatherManagerServer wm = ServerTickHandler.getWeatherManagerFor((ResourceKey<Level>)((CommandSourceStack)c.getSource()).m_81372_().m_46472_());
            wm.spawnParticleStorm(CoroUtilBlock.blockPos((Vec3)((CommandSourceStack)c.getSource()).m_81371_()), WeatherObjectParticleStorm.StormType.SANDSTORM);
            wm.getWindManager().stopLowWindEvent();
            wm.getWindManager().startHighWindEvent();
            ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)"Summoned sandstorm"), true);
            return 1;
        }))).then(Commands.m_82127_((String)"snowstorm_force").executes(c -> {
            WeatherManagerServer wm = ServerTickHandler.getWeatherManagerFor((ResourceKey<Level>)((CommandSourceStack)c.getSource()).m_81372_().m_46472_());
            wm.spawnParticleStorm(CoroUtilBlock.blockPos((Vec3)((CommandSourceStack)c.getSource()).m_81371_()), WeatherObjectParticleStorm.StormType.SNOWSTORM);
            wm.getWindManager().stopLowWindEvent();
            wm.getWindManager().startHighWindEvent();
            ((CommandSourceStack)c.getSource()).m_288197_(() -> Component.m_237113_((String)"Summoned snowstorm"), true);
            return 1;
        }))));
    }

    private static StormObject summonStorm(CommandContext<CommandSourceStack> c, int intensity) {
        WeatherManagerServer wm = ServerTickHandler.getWeatherManagerFor((ResourceKey<Level>)((CommandSourceStack)c.getSource()).m_81372_().m_46472_());
        StormObject stormObject = new StormObject(wm);
        stormObject.setupStorm(((CommandSourceStack)c.getSource()).m_81373_());
        stormObject.levelCurIntensityStage = intensity;
        stormObject.levelStormIntensityMax = intensity;
        stormObject.initPositions(new Vec3(((CommandSourceStack)c.getSource()).m_81371_().f_82479_, (double)StormObject.layers.get(stormObject.layer).intValue(), ((CommandSourceStack)c.getSource()).m_81371_().f_82481_));
        wm.addStormObject(stormObject);
        wm.syncStormNew(stormObject);
        return stormObject;
    }
}

